@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDdosBgpInstances.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of instance IDs.
 * @property instances A list of apis. Each element contains the following attributes:
 * @property nameRegex
 * @property names A list of instance names.
 * @property outputFile
 */
public data class GetDdosBgpInstancesResult(
    public val id: String,
    public val ids: List<String>,
    public val instances: List<GetDdosBgpInstancesInstance>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.GetDdosBgpInstancesResult): GetDdosBgpInstancesResult = GetDdosBgpInstancesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosBgpInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
