@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Ip. The value formats as `<instance_id>:<ip>`.
 * @property instanceId The ID of the native protection enterprise instance to be operated.
 * @property ip The IP address.
 * @property product The type of cloud asset to which the IP address belongs.
 * @property status The current state of the IP address.
 */
public data class GetDdosBgpIpsIp(
    public val id: String,
    public val instanceId: String,
    public val ip: String,
    public val product: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.GetDdosBgpIpsIp): GetDdosBgpIpsIp = GetDdosBgpIpsIp(
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            ip = javaType.ip(),
            product = javaType.product(),
            status = javaType.status(),
        )
    }
}
