@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDdosBgpIps.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property ips
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property productName
 * @property status
 */
public data class GetDdosBgpIpsResult(
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val ips: List<GetDdosBgpIpsIp>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val productName: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.GetDdosBgpIpsResult): GetDdosBgpIpsResult = GetDdosBgpIpsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            ips = javaType.ips().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosBgpIpsIp.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            productName = javaType.productName().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
