@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property blackLists The IP addresses in the blacklist for the domain name.
 * @property ccEnabled Whether frequency control guard (CC guard) is enabled. Values: `True`: Opened, `False`: Not enabled.
 * @property ccRuleEnabled Whether custom frequency control guard (CC guard) is enabled. Values: `True`: Opened, `False`: Not enabled.
 * @property ccTemplate The mode of the Frequency Control policy.
 * @property certName The name of the certificate.
 * @property domain The domain name of the website that you want to add to the instance.
 * @property http2Enable Whether Http2.0 is enabled.
 * @property httpsExt The advanced HTTPS settings.
 * @property id The ID of the Domain Resource.
 * @property instanceIds A list ID of instance that you want to associate.
 * @property policyMode The type of backload algorithm.
 * @property proxyEnabled Whether the website service forwarding rules have been turned on.
 * @property proxyTypes Protocol type and port number information.
 * @property realServers Server address information of the source station.
 * @property rsType Server address type.
 * @property sslCiphers The type of the cipher suite.
 * @property sslProtocols The version of the TLS protocol.
 * @property whiteLists The IP addresses in the whitelist for the domain name.
 */
public data class GetDdosCooDomainResourcesResource(
    public val blackLists: List<String>,
    public val ccEnabled: Boolean,
    public val ccRuleEnabled: Boolean,
    public val ccTemplate: String,
    public val certName: String,
    public val domain: String,
    public val http2Enable: Boolean,
    public val httpsExt: String,
    public val id: String,
    public val instanceIds: List<String>,
    public val policyMode: String,
    public val proxyEnabled: Boolean,
    public val proxyTypes: List<GetDdosCooDomainResourcesResourceProxyType>,
    public val realServers: List<String>,
    public val rsType: Int,
    public val sslCiphers: String,
    public val sslProtocols: String,
    public val whiteLists: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.GetDdosCooDomainResourcesResource): GetDdosCooDomainResourcesResource = GetDdosCooDomainResourcesResource(
            blackLists = javaType.blackLists().map({ args0 -> args0 }),
            ccEnabled = javaType.ccEnabled(),
            ccRuleEnabled = javaType.ccRuleEnabled(),
            ccTemplate = javaType.ccTemplate(),
            certName = javaType.certName(),
            domain = javaType.domain(),
            http2Enable = javaType.http2Enable(),
            httpsExt = javaType.httpsExt(),
            id = javaType.id(),
            instanceIds = javaType.instanceIds().map({ args0 -> args0 }),
            policyMode = javaType.policyMode(),
            proxyEnabled = javaType.proxyEnabled(),
            proxyTypes = javaType.proxyTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosCooDomainResourcesResourceProxyType.Companion.toKotlin(args0)
                })
            }),
            realServers = javaType.realServers().map({ args0 -> args0 }),
            rsType = javaType.rsType(),
            sslCiphers = javaType.sslCiphers(),
            sslProtocols = javaType.sslProtocols(),
            whiteLists = javaType.whiteLists().map({ args0 -> args0 }),
        )
    }
}
