@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDdosCooDomainResources.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceIds
 * @property outputFile
 * @property queryDomainPattern
 * @property resources
 */
public data class GetDdosCooDomainResourcesResult(
    public val id: String,
    public val ids: List<String>,
    public val instanceIds: List<String>? = null,
    public val outputFile: String? = null,
    public val queryDomainPattern: String? = null,
    public val resources: List<GetDdosCooDomainResourcesResource>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.GetDdosCooDomainResourcesResult): GetDdosCooDomainResourcesResult = GetDdosCooDomainResourcesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceIds = javaType.instanceIds().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            queryDomainPattern = javaType.queryDomainPattern().map({ args0 -> args0 }).orElse(null),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosCooDomainResourcesResource.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
