@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bandwidth The instance's elastic defend bandwidth.
 * @property baseBandwidth The instance's base defend bandwidth.
 * @property createTime The creation time of the instance.
 * @property debtStatus The debt status of the instance.
 * @property domainCount The instance's count of domain retransmission config.
 * @property edition The edition of the instance.
 * @property enabled The enabled of the instance.
 * @property expireTime The expiry time of the instance.
 * @property id The instance's id.
 * @property ipMode The ip mode of the instance.
 * @property ipVersion The ip version of the instance.
 * @property name The instance's remark.
 * @property portCount The instance's count of port retransmission config.
 * @property remark The remark of the instance.
 * @property serviceBandwidth The instance's business bandwidth.
 * @property status The status of the instance.
 */
public data class GetDdosCooInstancesInstance(
    public val bandwidth: Int,
    public val baseBandwidth: Int,
    public val createTime: Int,
    public val debtStatus: Int,
    public val domainCount: Int,
    public val edition: Int,
    public val enabled: Int,
    public val expireTime: Int,
    public val id: String,
    public val ipMode: String,
    public val ipVersion: String,
    public val name: String,
    public val portCount: Int,
    public val remark: String,
    public val serviceBandwidth: Int,
    public val status: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.GetDdosCooInstancesInstance): GetDdosCooInstancesInstance = GetDdosCooInstancesInstance(
            bandwidth = javaType.bandwidth(),
            baseBandwidth = javaType.baseBandwidth(),
            createTime = javaType.createTime(),
            debtStatus = javaType.debtStatus(),
            domainCount = javaType.domainCount(),
            edition = javaType.edition(),
            enabled = javaType.enabled(),
            expireTime = javaType.expireTime(),
            id = javaType.id(),
            ipMode = javaType.ipMode(),
            ipVersion = javaType.ipVersion(),
            name = javaType.name(),
            portCount = javaType.portCount(),
            remark = javaType.remark(),
            serviceBandwidth = javaType.serviceBandwidth(),
            status = javaType.status(),
        )
    }
}
