@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backendPort The source station port.
 * @property frontendPort The forwarding port.
 * @property frontendProtocol The forwarding protocol. Valid values `tcp` and `udp`.
 * @property id The ID of the Port.
 * @property instanceId The Ddoscoo instance ID.
 * @property realServers List of source IP addresses.
 */
public data class GetDdosCooPortsPort(
    public val backendPort: String,
    public val frontendPort: String,
    public val frontendProtocol: String,
    public val id: String,
    public val instanceId: String,
    public val realServers: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.GetDdosCooPortsPort): GetDdosCooPortsPort = GetDdosCooPortsPort(
            backendPort = javaType.backendPort(),
            frontendPort = javaType.frontendPort(),
            frontendProtocol = javaType.frontendProtocol(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            realServers = javaType.realServers().map({ args0 -> args0 }),
        )
    }
}
