@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDdosCooPorts.
 * @property frontendPort
 * @property frontendProtocol
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property outputFile
 * @property ports
 */
public data class GetDdosCooPortsResult(
    public val frontendPort: String? = null,
    public val frontendProtocol: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val outputFile: String? = null,
    public val ports: List<GetDdosCooPortsPort>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.GetDdosCooPortsResult): GetDdosCooPortsResult = GetDdosCooPortsResult(
            frontendPort = javaType.frontendPort().map({ args0 -> args0 }).orElse(null),
            frontendProtocol = javaType.frontendProtocol().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            ports = javaType.ports().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ddos.kotlin.outputs.GetDdosCooPortsPort.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
