@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ddos.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property priority The priority of the rule.
 * @property regionId The region where the interaction resource that is used in the scheduling rule is deployed. **NOTE:** This parameter is returned only if the RuleType parameter is set to 2.
 * @property status The status of the scheduling rule.
 * @property type The address type of the interaction resource. Valid values:
 * `A`: IPv4 address.
 * `CNAME`: CNAME record.
 * @property value The address of the interaction resource.
 * @property valueType Required. The type of the linked resource. It is an Integer. Valid values:
 * `1`: The IP address of Anti-DDoS Pro or Anti-DDoS Premium
 * `2`: the IP address of the interaction resource (in the tiered protection scenario)
 * `3`: the IP address used to accelerate access (in the network acceleration scenario)
 * `6` the IP address of the interaction resource (in the cloud service interaction scenario)
 */
public data class SchedulerRuleRule(
    public val priority: Int? = null,
    public val regionId: String? = null,
    public val status: Int? = null,
    public val type: String? = null,
    public val `value`: String? = null,
    public val valueType: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ddos.outputs.SchedulerRuleRule): SchedulerRuleRule = SchedulerRuleRule(
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            regionId = javaType.regionId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
            valueType = javaType.valueType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
