@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dds.kotlin

import com.pulumi.alicloud.dds.DdsFunctions.getMongoInstancesPlain
import com.pulumi.alicloud.dds.kotlin.inputs.GetMongoInstancesPlainArgs
import com.pulumi.alicloud.dds.kotlin.inputs.GetMongoInstancesPlainArgsBuilder
import com.pulumi.alicloud.dds.kotlin.outputs.GetMongoInstancesResult
import com.pulumi.alicloud.dds.kotlin.outputs.GetMongoInstancesResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

public object DdsFunctions {
    /**
     *
     * @param argument A collection of arguments for invoking getMongoInstances.
     * @return A collection of values returned by getMongoInstances.
     */
    public suspend fun getMongoInstances(argument: GetMongoInstancesPlainArgs): GetMongoInstancesResult = toKotlin(getMongoInstancesPlain(argument.toJava()).await())

    /**
     * @see [getMongoInstances].
     * @param availabilityZone
     * @param ids
     * @param instanceClass
     * @param instanceType
     * @param nameRegex
     * @param outputFile
     * @param tags
     * @return A collection of values returned by getMongoInstances.
     */
    public suspend fun getMongoInstances(
        availabilityZone: String? = null,
        ids: List<String>? = null,
        instanceClass: String? = null,
        instanceType: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetMongoInstancesResult {
        val argument = GetMongoInstancesPlainArgs(
            availabilityZone = availabilityZone,
            ids = ids,
            instanceClass = instanceClass,
            instanceType = instanceType,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tags = tags,
        )
        return toKotlin(getMongoInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getMongoInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dds&#46;kotlin&#46;inputs&#46;GetMongoInstancesPlainArgs].
     * @return A collection of values returned by getMongoInstances.
     */
    public suspend fun getMongoInstances(argument: suspend GetMongoInstancesPlainArgsBuilder.() -> Unit): GetMongoInstancesResult {
        val builder = GetMongoInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getMongoInstancesPlain(builtArgument.toJava()).await())
    }
}
