@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dds.kotlin.inputs

import com.pulumi.alicloud.dds.inputs.GetMongoInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMongoInstances.
 * @property availabilityZone
 * @property ids
 * @property instanceClass
 * @property instanceType
 * @property nameRegex
 * @property outputFile
 * @property tags
 */
public data class GetMongoInstancesPlainArgs(
    public val availabilityZone: String? = null,
    public val ids: List<String>? = null,
    public val instanceClass: String? = null,
    public val instanceType: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dds.inputs.GetMongoInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dds.inputs.GetMongoInstancesPlainArgs =
        com.pulumi.alicloud.dds.inputs.GetMongoInstancesPlainArgs.builder()
            .availabilityZone(availabilityZone?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceClass(instanceClass?.let({ args0 -> args0 }))
            .instanceType(instanceType?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetMongoInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetMongoInstancesPlainArgsBuilder internal constructor() {
    private var availabilityZone: String? = null

    private var ids: List<String>? = null

    private var instanceClass: String? = null

    private var instanceType: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value
     */
    @JvmName("sjmfjicsicodlubn")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availabilityZone = mapped
    }

    /**
     * @param value
     */
    @JvmName("ucvdolvbuaoglugi")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("cnkgayptbbqlgacy")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("rmdfravwbtewbvde")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceClass = mapped
    }

    /**
     * @param value
     */
    @JvmName("ssrbilkomcpmvotp")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    /**
     * @param value
     */
    @JvmName("ysitolvixswhaglj")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("ccrvssugkesqxxjd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("fwinkhpxjrjpkncu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("heypuhielvuotrau")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetMongoInstancesPlainArgs = GetMongoInstancesPlainArgs(
        availabilityZone = availabilityZone,
        ids = ids,
        instanceClass = instanceClass,
        instanceType = instanceType,
        nameRegex = nameRegex,
        outputFile = outputFile,
        tags = tags,
    )
}
