@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property availabilityZone
 * @property chargeType
 * @property creationTime
 * @property engine
 * @property engineVersion
 * @property expirationTime
 * @property id
 * @property instanceClass
 * @property instanceType
 * @property lockMode
 * @property mongos
 * @property name
 * @property networkType
 * @property regionId
 * @property replication
 * @property shards
 * @property status
 * @property storage
 * @property tags
 */
public data class GetMongoInstancesInstance(
    public val availabilityZone: String,
    public val chargeType: String,
    public val creationTime: String,
    public val engine: String,
    public val engineVersion: String,
    public val expirationTime: String,
    public val id: String,
    public val instanceClass: String,
    public val instanceType: String,
    public val lockMode: String,
    public val mongos: List<GetMongoInstancesInstanceMongo>,
    public val name: String,
    public val networkType: String,
    public val regionId: String,
    public val replication: String,
    public val shards: List<GetMongoInstancesInstanceShard>,
    public val status: String,
    public val storage: Int,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dds.outputs.GetMongoInstancesInstance): GetMongoInstancesInstance = GetMongoInstancesInstance(
            availabilityZone = javaType.availabilityZone(),
            chargeType = javaType.chargeType(),
            creationTime = javaType.creationTime(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            expirationTime = javaType.expirationTime(),
            id = javaType.id(),
            instanceClass = javaType.instanceClass(),
            instanceType = javaType.instanceType(),
            lockMode = javaType.lockMode(),
            mongos = javaType.mongos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dds.kotlin.outputs.GetMongoInstancesInstanceMongo.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            networkType = javaType.networkType(),
            regionId = javaType.regionId(),
            replication = javaType.replication(),
            shards = javaType.shards().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dds.kotlin.outputs.GetMongoInstancesInstanceShard.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            storage = javaType.storage(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
