@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccessGroup].
 */
@PulumiTagMarker
public class AccessGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessGroupArgs = AccessGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessGroupArgsBuilder.() -> Unit) {
        val builder = AccessGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessGroup {
        val builtJavaResource = com.pulumi.alicloud.dfs.AccessGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessGroup(builtJavaResource)
    }
}

/**
 * Provides a DFS Access Group resource.
 * For information about DFS Access Group and how to use it, see [What is Access Group](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).
 * > **NOTE:** Available since v1.133.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultAccessGroup = new alicloud.dfs.AccessGroup("default", {
 *     accessGroupName: `tf-example-${_default.result}`,
 *     networkType: "VPC",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_access_group = alicloud.dfs.AccessGroup("default",
 *     access_group_name=f"tf-example-{default['result']}",
 *     network_type="VPC")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultAccessGroup = new AliCloud.Dfs.AccessGroup("default", new()
 *     {
 *         AccessGroupName = $"tf-example-{@default.Result}",
 *         NetworkType = "VPC",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dfs"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dfs.NewAccessGroup(ctx, "default", &dfs.AccessGroupArgs{
 * 			AccessGroupName: pulumi.Sprintf("tf-example-%v", _default.Result),
 * 			NetworkType:     pulumi.String("VPC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.dfs.AccessGroup;
 * import com.pulumi.alicloud.dfs.AccessGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultAccessGroup = new AccessGroup("defaultAccessGroup", AccessGroupArgs.builder()
 *             .accessGroupName(String.format("tf-example-%s", default_.result()))
 *             .networkType("VPC")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultAccessGroup:
 *     type: alicloud:dfs:AccessGroup
 *     name: default
 *     properties:
 *       accessGroupName: tf-example-${default.result}
 *       networkType: VPC
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DFS Access Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dfs/accessGroup:AccessGroup example <id>
 * ```
 */
public class AccessGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.dfs.AccessGroup,
) : KotlinCustomResource(javaResource, AccessGroupMapper) {
    /**
     * The permission group name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
     */
    public val accessGroupName: Output<String>
        get() = javaResource.accessGroupName().applyValue({ args0 -> args0 })

    /**
     * The creation time of the permission group resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The permission group description.  No more than 32 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The permission group type. Only VPC (VPC) is supported.
     */
    public val networkType: Output<String>
        get() = javaResource.networkType().applyValue({ args0 -> args0 })
}

public object AccessGroupMapper : ResourceMapper<AccessGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dfs.AccessGroup::class == javaResource::class

    override fun map(javaResource: Resource): AccessGroup = AccessGroup(
        javaResource as
            com.pulumi.alicloud.dfs.AccessGroup,
    )
}

/**
 * @see [AccessGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessGroup].
 */
public suspend fun accessGroup(name: String, block: suspend AccessGroupResourceBuilder.() -> Unit): AccessGroup {
    val builder = AccessGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessGroup(name: String): AccessGroup {
    val builder = AccessGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
