@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin

import com.pulumi.alicloud.dfs.AccessGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DFS Access Group resource.
 * For information about DFS Access Group and how to use it, see [What is Access Group](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).
 * > **NOTE:** Available since v1.133.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultAccessGroup = new alicloud.dfs.AccessGroup("default", {
 *     accessGroupName: `tf-example-${_default.result}`,
 *     networkType: "VPC",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_access_group = alicloud.dfs.AccessGroup("default",
 *     access_group_name=f"tf-example-{default['result']}",
 *     network_type="VPC")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultAccessGroup = new AliCloud.Dfs.AccessGroup("default", new()
 *     {
 *         AccessGroupName = $"tf-example-{@default.Result}",
 *         NetworkType = "VPC",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dfs"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dfs.NewAccessGroup(ctx, "default", &dfs.AccessGroupArgs{
 * 			AccessGroupName: pulumi.Sprintf("tf-example-%v", _default.Result),
 * 			NetworkType:     pulumi.String("VPC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.dfs.AccessGroup;
 * import com.pulumi.alicloud.dfs.AccessGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultAccessGroup = new AccessGroup("defaultAccessGroup", AccessGroupArgs.builder()
 *             .accessGroupName(String.format("tf-example-%s", default_.result()))
 *             .networkType("VPC")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultAccessGroup:
 *     type: alicloud:dfs:AccessGroup
 *     name: default
 *     properties:
 *       accessGroupName: tf-example-${default.result}
 *       networkType: VPC
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DFS Access Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dfs/accessGroup:AccessGroup example <id>
 * ```
 * @property accessGroupName The permission group name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
 * @property description The permission group description.  No more than 32 characters in length.
 * @property networkType The permission group type. Only VPC (VPC) is supported.
 */
public data class AccessGroupArgs(
    public val accessGroupName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val networkType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dfs.AccessGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.dfs.AccessGroupArgs =
        com.pulumi.alicloud.dfs.AccessGroupArgs.builder()
            .accessGroupName(accessGroupName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .networkType(networkType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessGroupArgs].
 */
@PulumiTagMarker
public class AccessGroupArgsBuilder internal constructor() {
    private var accessGroupName: Output<String>? = null

    private var description: Output<String>? = null

    private var networkType: Output<String>? = null

    /**
     * @param value The permission group name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
     */
    @JvmName("yuvlsujnmdmkujeq")
    public suspend fun accessGroupName(`value`: Output<String>) {
        this.accessGroupName = value
    }

    /**
     * @param value The permission group description.  No more than 32 characters in length.
     */
    @JvmName("mmxdudrkvhuwqrul")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The permission group type. Only VPC (VPC) is supported.
     */
    @JvmName("xuwjdqcxumjgtxwl")
    public suspend fun networkType(`value`: Output<String>) {
        this.networkType = value
    }

    /**
     * @param value The permission group name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
     */
    @JvmName("nydbifbmjpapsfex")
    public suspend fun accessGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessGroupName = mapped
    }

    /**
     * @param value The permission group description.  No more than 32 characters in length.
     */
    @JvmName("sanwafhkrpcbfiyx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The permission group type. Only VPC (VPC) is supported.
     */
    @JvmName("qclgkdepbnogfbsp")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    internal fun build(): AccessGroupArgs = AccessGroupArgs(
        accessGroupName = accessGroupName,
        description = description,
        networkType = networkType,
    )
}
