@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccessRule].
 */
@PulumiTagMarker
public class AccessRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessRuleArgs = AccessRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessRuleArgsBuilder.() -> Unit) {
        val builder = AccessRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessRule {
        val builtJavaResource = com.pulumi.alicloud.dfs.AccessRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessRule(builtJavaResource)
    }
}

/**
 * Provides a DFS Access Rule resource.
 * For information about DFS Access Rule and how to use it, see [What is Access Rule](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).
 * > **NOTE:** Available since v1.140.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "example_name";
 * const _default = new alicloud.dfs.AccessGroup("default", {
 *     networkType: "VPC",
 *     accessGroupName: name,
 *     description: name,
 * });
 * const defaultAccessRule = new alicloud.dfs.AccessRule("default", {
 *     networkSegment: "192.0.2.0/24",
 *     accessGroupId: _default.id,
 *     description: name,
 *     rwAccessType: "RDWR",
 *     priority: 10,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "example_name"
 * default = alicloud.dfs.AccessGroup("default",
 *     network_type="VPC",
 *     access_group_name=name,
 *     description=name)
 * default_access_rule = alicloud.dfs.AccessRule("default",
 *     network_segment="192.0.2.0/24",
 *     access_group_id=default.id,
 *     description=name,
 *     rw_access_type="RDWR",
 *     priority=10)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "example_name";
 *     var @default = new AliCloud.Dfs.AccessGroup("default", new()
 *     {
 *         NetworkType = "VPC",
 *         AccessGroupName = name,
 *         Description = name,
 *     });
 *     var defaultAccessRule = new AliCloud.Dfs.AccessRule("default", new()
 *     {
 *         NetworkSegment = "192.0.2.0/24",
 *         AccessGroupId = @default.Id,
 *         Description = name,
 *         RwAccessType = "RDWR",
 *         Priority = 10,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dfs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "example_name"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := dfs.NewAccessGroup(ctx, "default", &dfs.AccessGroupArgs{
 * 			NetworkType:     pulumi.String("VPC"),
 * 			AccessGroupName: pulumi.String(name),
 * 			Description:     pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dfs.NewAccessRule(ctx, "default", &dfs.AccessRuleArgs{
 * 			NetworkSegment: pulumi.String("192.0.2.0/24"),
 * 			AccessGroupId:  _default.ID(),
 * 			Description:    pulumi.String(name),
 * 			RwAccessType:   pulumi.String("RDWR"),
 * 			Priority:       pulumi.Int(10),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dfs.AccessGroup;
 * import com.pulumi.alicloud.dfs.AccessGroupArgs;
 * import com.pulumi.alicloud.dfs.AccessRule;
 * import com.pulumi.alicloud.dfs.AccessRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("example_name");
 *         var default_ = new AccessGroup("default", AccessGroupArgs.builder()
 *             .networkType("VPC")
 *             .accessGroupName(name)
 *             .description(name)
 *             .build());
 *         var defaultAccessRule = new AccessRule("defaultAccessRule", AccessRuleArgs.builder()
 *             .networkSegment("192.0.2.0/24")
 *             .accessGroupId(default_.id())
 *             .description(name)
 *             .rwAccessType("RDWR")
 *             .priority("10")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: example_name
 * resources:
 *   default:
 *     type: alicloud:dfs:AccessGroup
 *     properties:
 *       networkType: VPC
 *       accessGroupName: ${name}
 *       description: ${name}
 *   defaultAccessRule:
 *     type: alicloud:dfs:AccessRule
 *     name: default
 *     properties:
 *       networkSegment: 192.0.2.0/24
 *       accessGroupId: ${default.id}
 *       description: ${name}
 *       rwAccessType: RDWR
 *       priority: '10'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DFS Access Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dfs/accessRule:AccessRule example <access_group_id>:<access_rule_id>
 * ```
 */
public class AccessRule internal constructor(
    override val javaResource: com.pulumi.alicloud.dfs.AccessRule,
) : KotlinCustomResource(javaResource, AccessRuleMapper) {
    /**
     * Permission group resource ID. You must specify the permission group ID when creating a permission rule.
     */
    public val accessGroupId: Output<String>
        get() = javaResource.accessGroupId().applyValue({ args0 -> args0 })

    /**
     * The unique identity of the permission rule, which is used to retrieve the permission rule for a specific day in the permission group.
     */
    public val accessRuleId: Output<String>
        get() = javaResource.accessRuleId().applyValue({ args0 -> args0 })

    /**
     * Permission rule resource creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Permission rule description.  No more than 32 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IP address or network segment of the authorized object.
     */
    public val networkSegment: Output<String>
        get() = javaResource.networkSegment().applyValue({ args0 -> args0 })

    /**
     * Permission rule priority. When the same authorization object matches multiple rules, the high-priority rule takes effect. Value range: 1~100,1 is the highest priority.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * The read and write permissions of the authorized object on the file system. Value: RDWR: readable and writable RDONLY: Read only.
     */
    public val rwAccessType: Output<String>
        get() = javaResource.rwAccessType().applyValue({ args0 -> args0 })
}

public object AccessRuleMapper : ResourceMapper<AccessRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dfs.AccessRule::class == javaResource::class

    override fun map(javaResource: Resource): AccessRule = AccessRule(
        javaResource as
            com.pulumi.alicloud.dfs.AccessRule,
    )
}

/**
 * @see [AccessRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessRule].
 */
public suspend fun accessRule(name: String, block: suspend AccessRuleResourceBuilder.() -> Unit): AccessRule {
    val builder = AccessRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessRule(name: String): AccessRule {
    val builder = AccessRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
