@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin

import com.pulumi.alicloud.dfs.AccessRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DFS Access Rule resource.
 * For information about DFS Access Rule and how to use it, see [What is Access Rule](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).
 * > **NOTE:** Available since v1.140.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "example_name";
 * const _default = new alicloud.dfs.AccessGroup("default", {
 *     networkType: "VPC",
 *     accessGroupName: name,
 *     description: name,
 * });
 * const defaultAccessRule = new alicloud.dfs.AccessRule("default", {
 *     networkSegment: "192.0.2.0/24",
 *     accessGroupId: _default.id,
 *     description: name,
 *     rwAccessType: "RDWR",
 *     priority: 10,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "example_name"
 * default = alicloud.dfs.AccessGroup("default",
 *     network_type="VPC",
 *     access_group_name=name,
 *     description=name)
 * default_access_rule = alicloud.dfs.AccessRule("default",
 *     network_segment="192.0.2.0/24",
 *     access_group_id=default.id,
 *     description=name,
 *     rw_access_type="RDWR",
 *     priority=10)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "example_name";
 *     var @default = new AliCloud.Dfs.AccessGroup("default", new()
 *     {
 *         NetworkType = "VPC",
 *         AccessGroupName = name,
 *         Description = name,
 *     });
 *     var defaultAccessRule = new AliCloud.Dfs.AccessRule("default", new()
 *     {
 *         NetworkSegment = "192.0.2.0/24",
 *         AccessGroupId = @default.Id,
 *         Description = name,
 *         RwAccessType = "RDWR",
 *         Priority = 10,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dfs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "example_name"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := dfs.NewAccessGroup(ctx, "default", &dfs.AccessGroupArgs{
 * 			NetworkType:     pulumi.String("VPC"),
 * 			AccessGroupName: pulumi.String(name),
 * 			Description:     pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dfs.NewAccessRule(ctx, "default", &dfs.AccessRuleArgs{
 * 			NetworkSegment: pulumi.String("192.0.2.0/24"),
 * 			AccessGroupId:  _default.ID(),
 * 			Description:    pulumi.String(name),
 * 			RwAccessType:   pulumi.String("RDWR"),
 * 			Priority:       pulumi.Int(10),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dfs.AccessGroup;
 * import com.pulumi.alicloud.dfs.AccessGroupArgs;
 * import com.pulumi.alicloud.dfs.AccessRule;
 * import com.pulumi.alicloud.dfs.AccessRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("example_name");
 *         var default_ = new AccessGroup("default", AccessGroupArgs.builder()
 *             .networkType("VPC")
 *             .accessGroupName(name)
 *             .description(name)
 *             .build());
 *         var defaultAccessRule = new AccessRule("defaultAccessRule", AccessRuleArgs.builder()
 *             .networkSegment("192.0.2.0/24")
 *             .accessGroupId(default_.id())
 *             .description(name)
 *             .rwAccessType("RDWR")
 *             .priority("10")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: example_name
 * resources:
 *   default:
 *     type: alicloud:dfs:AccessGroup
 *     properties:
 *       networkType: VPC
 *       accessGroupName: ${name}
 *       description: ${name}
 *   defaultAccessRule:
 *     type: alicloud:dfs:AccessRule
 *     name: default
 *     properties:
 *       networkSegment: 192.0.2.0/24
 *       accessGroupId: ${default.id}
 *       description: ${name}
 *       rwAccessType: RDWR
 *       priority: '10'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DFS Access Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dfs/accessRule:AccessRule example <access_group_id>:<access_rule_id>
 * ```
 * @property accessGroupId Permission group resource ID. You must specify the permission group ID when creating a permission rule.
 * @property description Permission rule description.  No more than 32 characters in length.
 * @property networkSegment The IP address or network segment of the authorized object.
 * @property priority Permission rule priority. When the same authorization object matches multiple rules, the high-priority rule takes effect. Value range: 1~100,1 is the highest priority.
 * @property rwAccessType The read and write permissions of the authorized object on the file system. Value: RDWR: readable and writable RDONLY: Read only.
 */
public data class AccessRuleArgs(
    public val accessGroupId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val networkSegment: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val rwAccessType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dfs.AccessRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.dfs.AccessRuleArgs =
        com.pulumi.alicloud.dfs.AccessRuleArgs.builder()
            .accessGroupId(accessGroupId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .networkSegment(networkSegment?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .rwAccessType(rwAccessType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessRuleArgs].
 */
@PulumiTagMarker
public class AccessRuleArgsBuilder internal constructor() {
    private var accessGroupId: Output<String>? = null

    private var description: Output<String>? = null

    private var networkSegment: Output<String>? = null

    private var priority: Output<Int>? = null

    private var rwAccessType: Output<String>? = null

    /**
     * @param value Permission group resource ID. You must specify the permission group ID when creating a permission rule.
     */
    @JvmName("qulmimyrdlmgycud")
    public suspend fun accessGroupId(`value`: Output<String>) {
        this.accessGroupId = value
    }

    /**
     * @param value Permission rule description.  No more than 32 characters in length.
     */
    @JvmName("gawlslyaqkwjdwii")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The IP address or network segment of the authorized object.
     */
    @JvmName("cxcmcistepmuixnw")
    public suspend fun networkSegment(`value`: Output<String>) {
        this.networkSegment = value
    }

    /**
     * @param value Permission rule priority. When the same authorization object matches multiple rules, the high-priority rule takes effect. Value range: 1~100,1 is the highest priority.
     */
    @JvmName("bpwfukdnpyahkkro")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The read and write permissions of the authorized object on the file system. Value: RDWR: readable and writable RDONLY: Read only.
     */
    @JvmName("adirtenchqfltjly")
    public suspend fun rwAccessType(`value`: Output<String>) {
        this.rwAccessType = value
    }

    /**
     * @param value Permission group resource ID. You must specify the permission group ID when creating a permission rule.
     */
    @JvmName("ksgjvmfphpuijcvv")
    public suspend fun accessGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessGroupId = mapped
    }

    /**
     * @param value Permission rule description.  No more than 32 characters in length.
     */
    @JvmName("nyjnkkjmdbpaqbaj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The IP address or network segment of the authorized object.
     */
    @JvmName("vhmmbbdxycxwtyeq")
    public suspend fun networkSegment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSegment = mapped
    }

    /**
     * @param value Permission rule priority. When the same authorization object matches multiple rules, the high-priority rule takes effect. Value range: 1~100,1 is the highest priority.
     */
    @JvmName("upttughjsbjkjufv")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The read and write permissions of the authorized object on the file system. Value: RDWR: readable and writable RDONLY: Read only.
     */
    @JvmName("fwrjwyiiwqvevaxm")
    public suspend fun rwAccessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rwAccessType = mapped
    }

    internal fun build(): AccessRuleArgs = AccessRuleArgs(
        accessGroupId = accessGroupId,
        description = description,
        networkSegment = networkSegment,
        priority = priority,
        rwAccessType = rwAccessType,
    )
}
