@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin

import com.pulumi.alicloud.dfs.DfsFunctions.getAccessGroupsPlain
import com.pulumi.alicloud.dfs.DfsFunctions.getAccessRulesPlain
import com.pulumi.alicloud.dfs.DfsFunctions.getFileSystemsPlain
import com.pulumi.alicloud.dfs.DfsFunctions.getMountPointsPlain
import com.pulumi.alicloud.dfs.DfsFunctions.getZonesPlain
import com.pulumi.alicloud.dfs.kotlin.inputs.GetAccessGroupsPlainArgs
import com.pulumi.alicloud.dfs.kotlin.inputs.GetAccessGroupsPlainArgsBuilder
import com.pulumi.alicloud.dfs.kotlin.inputs.GetAccessRulesPlainArgs
import com.pulumi.alicloud.dfs.kotlin.inputs.GetAccessRulesPlainArgsBuilder
import com.pulumi.alicloud.dfs.kotlin.inputs.GetFileSystemsPlainArgs
import com.pulumi.alicloud.dfs.kotlin.inputs.GetFileSystemsPlainArgsBuilder
import com.pulumi.alicloud.dfs.kotlin.inputs.GetMountPointsPlainArgs
import com.pulumi.alicloud.dfs.kotlin.inputs.GetMountPointsPlainArgsBuilder
import com.pulumi.alicloud.dfs.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.dfs.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.dfs.kotlin.outputs.GetAccessGroupsResult
import com.pulumi.alicloud.dfs.kotlin.outputs.GetAccessRulesResult
import com.pulumi.alicloud.dfs.kotlin.outputs.GetFileSystemsResult
import com.pulumi.alicloud.dfs.kotlin.outputs.GetMountPointsResult
import com.pulumi.alicloud.dfs.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.dfs.kotlin.outputs.GetAccessGroupsResult.Companion.toKotlin as getAccessGroupsResultToKotlin
import com.pulumi.alicloud.dfs.kotlin.outputs.GetAccessRulesResult.Companion.toKotlin as getAccessRulesResultToKotlin
import com.pulumi.alicloud.dfs.kotlin.outputs.GetFileSystemsResult.Companion.toKotlin as getFileSystemsResultToKotlin
import com.pulumi.alicloud.dfs.kotlin.outputs.GetMountPointsResult.Companion.toKotlin as getMountPointsResultToKotlin
import com.pulumi.alicloud.dfs.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object DfsFunctions {
    /**
     * This data source provides the Apsara File Storage for HDFS Access Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.133.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dfs.getAccessGroups({
     *     ids: ["example_id"],
     * });
     * export const dfsAccessGroupId1 = ids.then(ids => ids.groups?.[0]?.id);
     * const nameRegex = alicloud.dfs.getAccessGroups({
     *     nameRegex: "^my-AccessGroup",
     * });
     * export const dfsAccessGroupId2 = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dfs.get_access_groups(ids=["example_id"])
     * pulumi.export("dfsAccessGroupId1", ids.groups[0].id)
     * name_regex = alicloud.dfs.get_access_groups(name_regex="^my-AccessGroup")
     * pulumi.export("dfsAccessGroupId2", name_regex.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dfs.GetAccessGroups.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Dfs.GetAccessGroups.Invoke(new()
     *     {
     *         NameRegex = "^my-AccessGroup",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["dfsAccessGroupId1"] = ids&#46;Apply(getAccessGroupsResult => getAccessGroupsResult&#46;Groups[0]?.Id),
     *         ["dfsAccessGroupId2"] = nameRegex&#46;Apply(getAccessGroupsResult => getAccessGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dfs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dfs.GetAccessGroups(ctx, &dfs.GetAccessGroupsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dfsAccessGroupId1", ids.Groups[0].Id)
     * 		nameRegex, err := dfs.GetAccessGroups(ctx, &dfs.GetAccessGroupsArgs{
     * 			NameRegex: pulumi.StringRef("^my-AccessGroup"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dfsAccessGroupId2", nameRegex.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dfs.DfsFunctions;
     * import com.pulumi.alicloud.dfs.inputs.GetAccessGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DfsFunctions.getAccessGroups(GetAccessGroupsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("dfsAccessGroupId1", ids.applyValue(getAccessGroupsResult -> getAccessGroupsResult.groups()[0].id()));
     *         final var nameRegex = DfsFunctions.getAccessGroups(GetAccessGroupsArgs.builder()
     *             .nameRegex("^my-AccessGroup")
     *             .build());
     *         ctx.export("dfsAccessGroupId2", nameRegex.applyValue(getAccessGroupsResult -> getAccessGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dfs:getAccessGroups
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:dfs:getAccessGroups
     *       Arguments:
     *         nameRegex: ^my-AccessGroup
     * outputs:
     *   dfsAccessGroupId1: ${ids.groups[0].id}
     *   dfsAccessGroupId2: ${nameRegex.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccessGroups.
     * @return A collection of values returned by getAccessGroups.
     */
    public suspend fun getAccessGroups(argument: GetAccessGroupsPlainArgs): GetAccessGroupsResult =
        getAccessGroupsResultToKotlin(getAccessGroupsPlain(argument.toJava()).await())

    /**
     * @see [getAccessGroups].
     * @param ids A list of Access Group IDs.
     * @param limit
     * @param nameRegex A regex string to filter results by Access Group name.
     * @param orderBy
     * @param orderType
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param startOffset
     * @return A collection of values returned by getAccessGroups.
     */
    public suspend fun getAccessGroups(
        ids: List<String>? = null,
        limit: Int? = null,
        nameRegex: String? = null,
        orderBy: String? = null,
        orderType: String? = null,
        outputFile: String? = null,
        startOffset: Int? = null,
    ): GetAccessGroupsResult {
        val argument = GetAccessGroupsPlainArgs(
            ids = ids,
            limit = limit,
            nameRegex = nameRegex,
            orderBy = orderBy,
            orderType = orderType,
            outputFile = outputFile,
            startOffset = startOffset,
        )
        return getAccessGroupsResultToKotlin(getAccessGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dfs&#46;kotlin&#46;inputs&#46;GetAccessGroupsPlainArgs].
     * @return A collection of values returned by getAccessGroups.
     */
    public suspend fun getAccessGroups(argument: suspend GetAccessGroupsPlainArgsBuilder.() -> Unit): GetAccessGroupsResult {
        val builder = GetAccessGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessGroupsResultToKotlin(getAccessGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Dfs Access Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.140.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dfs.getAccessRules({
     *     accessGroupId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const dfsAccessRuleId1 = ids.then(ids => ids.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dfs.get_access_rules(access_group_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("dfsAccessRuleId1", ids.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dfs.GetAccessRules.Invoke(new()
     *     {
     *         AccessGroupId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["dfsAccessRuleId1"] = ids&#46;Apply(getAccessRulesResult => getAccessRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dfs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dfs.GetAccessRules(ctx, &dfs.GetAccessRulesArgs{
     * 			AccessGroupId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dfsAccessRuleId1", ids.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dfs.DfsFunctions;
     * import com.pulumi.alicloud.dfs.inputs.GetAccessRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DfsFunctions.getAccessRules(GetAccessRulesArgs.builder()
     *             .accessGroupId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("dfsAccessRuleId1", ids.applyValue(getAccessRulesResult -> getAccessRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dfs:getAccessRules
     *       Arguments:
     *         accessGroupId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   dfsAccessRuleId1: ${ids.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccessRules.
     * @return A collection of values returned by getAccessRules.
     */
    public suspend fun getAccessRules(argument: GetAccessRulesPlainArgs): GetAccessRulesResult =
        getAccessRulesResultToKotlin(getAccessRulesPlain(argument.toJava()).await())

    /**
     * @see [getAccessRules].
     * @param accessGroupId The resource ID of the Access Group.
     * @param ids A list of Access Rule IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getAccessRules.
     */
    public suspend fun getAccessRules(
        accessGroupId: String,
        ids: List<String>? = null,
        outputFile: String? = null,
    ): GetAccessRulesResult {
        val argument = GetAccessRulesPlainArgs(
            accessGroupId = accessGroupId,
            ids = ids,
            outputFile = outputFile,
        )
        return getAccessRulesResultToKotlin(getAccessRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dfs&#46;kotlin&#46;inputs&#46;GetAccessRulesPlainArgs].
     * @return A collection of values returned by getAccessRules.
     */
    public suspend fun getAccessRules(argument: suspend GetAccessRulesPlainArgsBuilder.() -> Unit): GetAccessRulesResult {
        val builder = GetAccessRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessRulesResultToKotlin(getAccessRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Dfs File Systems of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.140.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dfs.getFileSystems({
     *     ids: ["example_id"],
     * });
     * export const dfsFileSystemId1 = ids.then(ids => ids.systems?.[0]?.id);
     * const nameRegex = alicloud.dfs.getFileSystems({
     *     nameRegex: "^my-FileSystem",
     * });
     * export const dfsFileSystemId2 = nameRegex.then(nameRegex => nameRegex.systems?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dfs.get_file_systems(ids=["example_id"])
     * pulumi.export("dfsFileSystemId1", ids.systems[0].id)
     * name_regex = alicloud.dfs.get_file_systems(name_regex="^my-FileSystem")
     * pulumi.export("dfsFileSystemId2", name_regex.systems[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dfs.GetFileSystems.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Dfs.GetFileSystems.Invoke(new()
     *     {
     *         NameRegex = "^my-FileSystem",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["dfsFileSystemId1"] = ids&#46;Apply(getFileSystemsResult => getFileSystemsResult&#46;Systems[0]?.Id),
     *         ["dfsFileSystemId2"] = nameRegex&#46;Apply(getFileSystemsResult => getFileSystemsResult&#46;Systems[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dfs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dfs.GetFileSystems(ctx, &dfs.GetFileSystemsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dfsFileSystemId1", ids.Systems[0].Id)
     * 		nameRegex, err := dfs.GetFileSystems(ctx, &dfs.GetFileSystemsArgs{
     * 			NameRegex: pulumi.StringRef("^my-FileSystem"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dfsFileSystemId2", nameRegex.Systems[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dfs.DfsFunctions;
     * import com.pulumi.alicloud.dfs.inputs.GetFileSystemsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DfsFunctions.getFileSystems(GetFileSystemsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("dfsFileSystemId1", ids.applyValue(getFileSystemsResult -> getFileSystemsResult.systems()[0].id()));
     *         final var nameRegex = DfsFunctions.getFileSystems(GetFileSystemsArgs.builder()
     *             .nameRegex("^my-FileSystem")
     *             .build());
     *         ctx.export("dfsFileSystemId2", nameRegex.applyValue(getFileSystemsResult -> getFileSystemsResult.systems()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dfs:getFileSystems
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:dfs:getFileSystems
     *       Arguments:
     *         nameRegex: ^my-FileSystem
     * outputs:
     *   dfsFileSystemId1: ${ids.systems[0].id}
     *   dfsFileSystemId2: ${nameRegex.systems[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFileSystems.
     * @return A collection of values returned by getFileSystems.
     */
    public suspend fun getFileSystems(argument: GetFileSystemsPlainArgs): GetFileSystemsResult =
        getFileSystemsResultToKotlin(getFileSystemsPlain(argument.toJava()).await())

    /**
     * @see [getFileSystems].
     * @param ids A list of File System IDs.
     * @param nameRegex A regex string to filter results by File System name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getFileSystems.
     */
    public suspend fun getFileSystems(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetFileSystemsResult {
        val argument = GetFileSystemsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getFileSystemsResultToKotlin(getFileSystemsPlain(argument.toJava()).await())
    }

    /**
     * @see [getFileSystems].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dfs&#46;kotlin&#46;inputs&#46;GetFileSystemsPlainArgs].
     * @return A collection of values returned by getFileSystems.
     */
    public suspend fun getFileSystems(argument: suspend GetFileSystemsPlainArgsBuilder.() -> Unit): GetFileSystemsResult {
        val builder = GetFileSystemsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFileSystemsResultToKotlin(getFileSystemsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Dfs Mount Points of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.140.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.dfs.getMountPoints({
     *     fileSystemId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const dfsMountPointId1 = ids.then(ids => ids.points?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.dfs.get_mount_points(file_system_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("dfsMountPointId1", ids.points[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Dfs.GetMountPoints.Invoke(new()
     *     {
     *         FileSystemId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["dfsMountPointId1"] = ids&#46;Apply(getMountPointsResult => getMountPointsResult&#46;Points[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dfs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := dfs.GetMountPoints(ctx, &dfs.GetMountPointsArgs{
     * 			FileSystemId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("dfsMountPointId1", ids.Points[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dfs.DfsFunctions;
     * import com.pulumi.alicloud.dfs.inputs.GetMountPointsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DfsFunctions.getMountPoints(GetMountPointsArgs.builder()
     *             .fileSystemId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("dfsMountPointId1", ids.applyValue(getMountPointsResult -> getMountPointsResult.points()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:dfs:getMountPoints
     *       Arguments:
     *         fileSystemId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   dfsMountPointId1: ${ids.points[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMountPoints.
     * @return A collection of values returned by getMountPoints.
     */
    public suspend fun getMountPoints(argument: GetMountPointsPlainArgs): GetMountPointsResult =
        getMountPointsResultToKotlin(getMountPointsPlain(argument.toJava()).await())

    /**
     * @see [getMountPoints].
     * @param fileSystemId The ID of the File System.
     * @param ids A list of Mount Point IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the Mount Point. Valid values: `Active`, `Inactive`.
     * @return A collection of values returned by getMountPoints.
     */
    public suspend fun getMountPoints(
        fileSystemId: String,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetMountPointsResult {
        val argument = GetMountPointsPlainArgs(
            fileSystemId = fileSystemId,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getMountPointsResultToKotlin(getMountPointsPlain(argument.toJava()).await())
    }

    /**
     * @see [getMountPoints].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dfs&#46;kotlin&#46;inputs&#46;GetMountPointsPlainArgs].
     * @return A collection of values returned by getMountPoints.
     */
    public suspend fun getMountPoints(argument: suspend GetMountPointsPlainArgsBuilder.() -> Unit): GetMountPointsResult {
        val builder = GetMountPointsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMountPointsResultToKotlin(getMountPointsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the DFS Zones And Configurations of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.140.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.dfs.getZones({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.dfs.get_zones()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Dfs.GetZones.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dfs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := dfs.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.dfs.DfsFunctions;
     * import com.pulumi.alicloud.dfs.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = DfsFunctions.getZones();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:dfs:getZones
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;dfs&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
