@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FileSystem].
 */
@PulumiTagMarker
public class FileSystemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FileSystemArgs = FileSystemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FileSystemArgsBuilder.() -> Unit) {
        val builder = FileSystemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FileSystem {
        val builtJavaResource = com.pulumi.alicloud.dfs.FileSystem(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FileSystem(builtJavaResource)
    }
}

/**
 * Provides a DFS File System resource.
 * For information about DFS File System and how to use it, see [What is File System](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).
 * > **NOTE:** Available since v1.140.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.dfs.getZones({});
 * const defaultFileSystem = new alicloud.dfs.FileSystem("default", {
 *     storageType: _default.then(_default => _default.zones?.[0]?&#46;options?&#46;[0]?.storageType),
 *     zoneId: _default.then(_default => _default.zones?.[0]?.zoneId),
 *     protocolType: "HDFS",
 *     description: name,
 *     fileSystemName: name,
 *     throughputMode: "Provisioned",
 *     spaceCapacity: 1024,
 *     provisionedThroughputInMiBps: 512,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.dfs.get_zones()
 * default_file_system = alicloud.dfs.FileSystem("default",
 *     storage_type=default.zones[0]&#46;options[0].storage_type,
 *     zone_id=default.zones[0].zone_id,
 *     protocol_type="HDFS",
 *     description=name,
 *     file_system_name=name,
 *     throughput_mode="Provisioned",
 *     space_capacity=1024,
 *     provisioned_throughput_in_mi_bps=512)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.Dfs.GetZones.Invoke();
 *     var defaultFileSystem = new AliCloud.Dfs.FileSystem("default", new()
 *     {
 *         StorageType = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?&#46;Options[0]?.StorageType)),
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.ZoneId)),
 *         ProtocolType = "HDFS",
 *         Description = name,
 *         FileSystemName = name,
 *         ThroughputMode = "Provisioned",
 *         SpaceCapacity = 1024,
 *         ProvisionedThroughputInMiBps = 512,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dfs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := dfs.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dfs.NewFileSystem(ctx, "default", &dfs.FileSystemArgs{
 * 			StorageType:                  pulumi.String(_default.Zones[0]&#46;Options[0].StorageType),
 * 			ZoneId:                       pulumi.String(_default.Zones[0].ZoneId),
 * 			ProtocolType:                 pulumi.String("HDFS"),
 * 			Description:                  pulumi.String(name),
 * 			FileSystemName:               pulumi.String(name),
 * 			ThroughputMode:               pulumi.String("Provisioned"),
 * 			SpaceCapacity:                pulumi.Int(1024),
 * 			ProvisionedThroughputInMiBps: pulumi.Int(512),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dfs.DfsFunctions;
 * import com.pulumi.alicloud.dfs.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.dfs.FileSystem;
 * import com.pulumi.alicloud.dfs.FileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = DfsFunctions.getZones();
 *         var defaultFileSystem = new FileSystem("defaultFileSystem", FileSystemArgs.builder()
 *             .storageType(default_.zones()[0]&#46;options()[0].storageType())
 *             .zoneId(default_.zones()[0].zoneId())
 *             .protocolType("HDFS")
 *             .description(name)
 *             .fileSystemName(name)
 *             .throughputMode("Provisioned")
 *             .spaceCapacity("1024")
 *             .provisionedThroughputInMiBps("512")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultFileSystem:
 *     type: alicloud:dfs:FileSystem
 *     name: default
 *     properties:
 *       storageType: ${default.zones[0]&#46;options[0].storageType}
 *       zoneId: ${default.zones[0].zoneId}
 *       protocolType: HDFS
 *       description: ${name}
 *       fileSystemName: ${name}
 *       throughputMode: Provisioned
 *       spaceCapacity: '1024'
 *       provisionedThroughputInMiBps: '512'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:dfs:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DFS File System can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dfs/fileSystem:FileSystem example <id>
 * ```
 */
public class FileSystem internal constructor(
    override val javaResource: com.pulumi.alicloud.dfs.FileSystem,
) : KotlinCustomResource(javaResource, FileSystemMapper) {
    /**
     * The creation time of the file system instance.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Redundancy mode of the file system. Value:
     * - LRS (default): Local redundancy.
     * - ZRS: Same-City redundancy. When ZRS is selected, zoneId is a string consisting of multiple zones that are expected to be redundant in the same city, for example,  'zoneId1,zoneId2 '.
     */
    public val dataRedundancyType: Output<String>?
        get() = javaResource.dataRedundancyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val dedicatedClusterId: Output<String>?
        get() = javaResource.dedicatedClusterId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the file system resource. No more than 32 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The file system name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
     */
    public val fileSystemName: Output<String>
        get() = javaResource.fileSystemName().applyValue({ args0 -> args0 })

    /**
     * Save set sequence number, the user selects the content of the specified sequence number in the Save set.
     */
    public val partitionNumber: Output<Int>?
        get() = javaResource.partitionNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The protocol type.  Only HDFS(Hadoop Distributed File System) is supported.
     */
    public val protocolType: Output<String>
        get() = javaResource.protocolType().applyValue({ args0 -> args0 })

    /**
     * Provisioned throughput. This parameter is required when ThroughputMode is set to Provisioned. Unit: MB/s Value range: 1~5120.
     */
    public val provisionedThroughputInMiBps: Output<Int>?
        get() = javaResource.provisionedThroughputInMiBps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * File system capacity.  When the actual amount of data stored reaches the capacity of the file system, data cannot be written.  Unit: GiB.
     */
    public val spaceCapacity: Output<Int>
        get() = javaResource.spaceCapacity().applyValue({ args0 -> args0 })

    /**
     * Save set identity, used to select a user-specified save set.
     */
    public val storageSetName: Output<String>?
        get() = javaResource.storageSetName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The storage media type. Value: STANDARD (default): STANDARD PERFORMANCE: PERFORMANCE type.
     */
    public val storageType: Output<String>
        get() = javaResource.storageType().applyValue({ args0 -> args0 })

    /**
     * The throughput mode. Value: Standard (default): Standard throughput Provisioned: preset throughput.
     */
    public val throughputMode: Output<String>
        get() = javaResource.throughputMode().applyValue({ args0 -> args0 })

    /**
     * Zone Id, which is used to create file system resources to the specified zone.
     */
    public val zoneId: Output<String>?
        get() = javaResource.zoneId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object FileSystemMapper : ResourceMapper<FileSystem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dfs.FileSystem::class == javaResource::class

    override fun map(javaResource: Resource): FileSystem = FileSystem(
        javaResource as
            com.pulumi.alicloud.dfs.FileSystem,
    )
}

/**
 * @see [FileSystem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FileSystem].
 */
public suspend fun fileSystem(name: String, block: suspend FileSystemResourceBuilder.() -> Unit): FileSystem {
    val builder = FileSystemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FileSystem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fileSystem(name: String): FileSystem {
    val builder = FileSystemResourceBuilder()
    builder.name(name)
    return builder.build()
}
