@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin

import com.pulumi.alicloud.dfs.FileSystemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DFS File System resource.
 * For information about DFS File System and how to use it, see [What is File System](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).
 * > **NOTE:** Available since v1.140.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.dfs.getZones({});
 * const defaultFileSystem = new alicloud.dfs.FileSystem("default", {
 *     storageType: _default.then(_default => _default.zones?.[0]?&#46;options?&#46;[0]?.storageType),
 *     zoneId: _default.then(_default => _default.zones?.[0]?.zoneId),
 *     protocolType: "HDFS",
 *     description: name,
 *     fileSystemName: name,
 *     throughputMode: "Provisioned",
 *     spaceCapacity: 1024,
 *     provisionedThroughputInMiBps: 512,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.dfs.get_zones()
 * default_file_system = alicloud.dfs.FileSystem("default",
 *     storage_type=default.zones[0]&#46;options[0].storage_type,
 *     zone_id=default.zones[0].zone_id,
 *     protocol_type="HDFS",
 *     description=name,
 *     file_system_name=name,
 *     throughput_mode="Provisioned",
 *     space_capacity=1024,
 *     provisioned_throughput_in_mi_bps=512)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.Dfs.GetZones.Invoke();
 *     var defaultFileSystem = new AliCloud.Dfs.FileSystem("default", new()
 *     {
 *         StorageType = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?&#46;Options[0]?.StorageType)),
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.ZoneId)),
 *         ProtocolType = "HDFS",
 *         Description = name,
 *         FileSystemName = name,
 *         ThroughputMode = "Provisioned",
 *         SpaceCapacity = 1024,
 *         ProvisionedThroughputInMiBps = 512,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dfs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := dfs.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dfs.NewFileSystem(ctx, "default", &dfs.FileSystemArgs{
 * 			StorageType:                  pulumi.String(_default.Zones[0]&#46;Options[0].StorageType),
 * 			ZoneId:                       pulumi.String(_default.Zones[0].ZoneId),
 * 			ProtocolType:                 pulumi.String("HDFS"),
 * 			Description:                  pulumi.String(name),
 * 			FileSystemName:               pulumi.String(name),
 * 			ThroughputMode:               pulumi.String("Provisioned"),
 * 			SpaceCapacity:                pulumi.Int(1024),
 * 			ProvisionedThroughputInMiBps: pulumi.Int(512),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dfs.DfsFunctions;
 * import com.pulumi.alicloud.dfs.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.dfs.FileSystem;
 * import com.pulumi.alicloud.dfs.FileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = DfsFunctions.getZones();
 *         var defaultFileSystem = new FileSystem("defaultFileSystem", FileSystemArgs.builder()
 *             .storageType(default_.zones()[0]&#46;options()[0].storageType())
 *             .zoneId(default_.zones()[0].zoneId())
 *             .protocolType("HDFS")
 *             .description(name)
 *             .fileSystemName(name)
 *             .throughputMode("Provisioned")
 *             .spaceCapacity("1024")
 *             .provisionedThroughputInMiBps("512")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultFileSystem:
 *     type: alicloud:dfs:FileSystem
 *     name: default
 *     properties:
 *       storageType: ${default.zones[0]&#46;options[0].storageType}
 *       zoneId: ${default.zones[0].zoneId}
 *       protocolType: HDFS
 *       description: ${name}
 *       fileSystemName: ${name}
 *       throughputMode: Provisioned
 *       spaceCapacity: '1024'
 *       provisionedThroughputInMiBps: '512'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:dfs:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DFS File System can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dfs/fileSystem:FileSystem example <id>
 * ```
 * @property dataRedundancyType Redundancy mode of the file system. Value:
 * - LRS (default): Local redundancy.
 * - ZRS: Same-City redundancy. When ZRS is selected, zoneId is a string consisting of multiple zones that are expected to be redundant in the same city, for example,  'zoneId1,zoneId2 '.
 * @property dedicatedClusterId
 * @property description The description of the file system resource. No more than 32 characters in length.
 * @property fileSystemName The file system name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
 * @property partitionNumber Save set sequence number, the user selects the content of the specified sequence number in the Save set.
 * @property protocolType The protocol type.  Only HDFS(Hadoop Distributed File System) is supported.
 * @property provisionedThroughputInMiBps Provisioned throughput. This parameter is required when ThroughputMode is set to Provisioned. Unit: MB/s Value range: 1~5120.
 * @property spaceCapacity File system capacity.  When the actual amount of data stored reaches the capacity of the file system, data cannot be written.  Unit: GiB.
 * @property storageSetName Save set identity, used to select a user-specified save set.
 * @property storageType The storage media type. Value: STANDARD (default): STANDARD PERFORMANCE: PERFORMANCE type.
 * @property throughputMode The throughput mode. Value: Standard (default): Standard throughput Provisioned: preset throughput.
 * @property zoneId Zone Id, which is used to create file system resources to the specified zone.
 */
public data class FileSystemArgs(
    public val dataRedundancyType: Output<String>? = null,
    public val dedicatedClusterId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val fileSystemName: Output<String>? = null,
    public val partitionNumber: Output<Int>? = null,
    public val protocolType: Output<String>? = null,
    public val provisionedThroughputInMiBps: Output<Int>? = null,
    public val spaceCapacity: Output<Int>? = null,
    public val storageSetName: Output<String>? = null,
    public val storageType: Output<String>? = null,
    public val throughputMode: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dfs.FileSystemArgs> {
    override fun toJava(): com.pulumi.alicloud.dfs.FileSystemArgs =
        com.pulumi.alicloud.dfs.FileSystemArgs.builder()
            .dataRedundancyType(dataRedundancyType?.applyValue({ args0 -> args0 }))
            .dedicatedClusterId(dedicatedClusterId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fileSystemName(fileSystemName?.applyValue({ args0 -> args0 }))
            .partitionNumber(partitionNumber?.applyValue({ args0 -> args0 }))
            .protocolType(protocolType?.applyValue({ args0 -> args0 }))
            .provisionedThroughputInMiBps(provisionedThroughputInMiBps?.applyValue({ args0 -> args0 }))
            .spaceCapacity(spaceCapacity?.applyValue({ args0 -> args0 }))
            .storageSetName(storageSetName?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .throughputMode(throughputMode?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileSystemArgs].
 */
@PulumiTagMarker
public class FileSystemArgsBuilder internal constructor() {
    private var dataRedundancyType: Output<String>? = null

    private var dedicatedClusterId: Output<String>? = null

    private var description: Output<String>? = null

    private var fileSystemName: Output<String>? = null

    private var partitionNumber: Output<Int>? = null

    private var protocolType: Output<String>? = null

    private var provisionedThroughputInMiBps: Output<Int>? = null

    private var spaceCapacity: Output<Int>? = null

    private var storageSetName: Output<String>? = null

    private var storageType: Output<String>? = null

    private var throughputMode: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Redundancy mode of the file system. Value:
     * - LRS (default): Local redundancy.
     * - ZRS: Same-City redundancy. When ZRS is selected, zoneId is a string consisting of multiple zones that are expected to be redundant in the same city, for example,  'zoneId1,zoneId2 '.
     */
    @JvmName("eenwobeqicsolwbk")
    public suspend fun dataRedundancyType(`value`: Output<String>) {
        this.dataRedundancyType = value
    }

    /**
     * @param value
     */
    @JvmName("derwdpcbhllggcon")
    public suspend fun dedicatedClusterId(`value`: Output<String>) {
        this.dedicatedClusterId = value
    }

    /**
     * @param value The description of the file system resource. No more than 32 characters in length.
     */
    @JvmName("sosqbkixfmsmtuhx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The file system name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
     */
    @JvmName("uwijscykhmtnswsa")
    public suspend fun fileSystemName(`value`: Output<String>) {
        this.fileSystemName = value
    }

    /**
     * @param value Save set sequence number, the user selects the content of the specified sequence number in the Save set.
     */
    @JvmName("edommatjhqjxxmbr")
    public suspend fun partitionNumber(`value`: Output<Int>) {
        this.partitionNumber = value
    }

    /**
     * @param value The protocol type.  Only HDFS(Hadoop Distributed File System) is supported.
     */
    @JvmName("qggrddhpspwfcmcd")
    public suspend fun protocolType(`value`: Output<String>) {
        this.protocolType = value
    }

    /**
     * @param value Provisioned throughput. This parameter is required when ThroughputMode is set to Provisioned. Unit: MB/s Value range: 1~5120.
     */
    @JvmName("mevcttkkfmpjdfrc")
    public suspend fun provisionedThroughputInMiBps(`value`: Output<Int>) {
        this.provisionedThroughputInMiBps = value
    }

    /**
     * @param value File system capacity.  When the actual amount of data stored reaches the capacity of the file system, data cannot be written.  Unit: GiB.
     */
    @JvmName("ocuxfuoyymiejgnm")
    public suspend fun spaceCapacity(`value`: Output<Int>) {
        this.spaceCapacity = value
    }

    /**
     * @param value Save set identity, used to select a user-specified save set.
     */
    @JvmName("jkganeiuxrjbsldi")
    public suspend fun storageSetName(`value`: Output<String>) {
        this.storageSetName = value
    }

    /**
     * @param value The storage media type. Value: STANDARD (default): STANDARD PERFORMANCE: PERFORMANCE type.
     */
    @JvmName("sjxagyppltbqmexv")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value The throughput mode. Value: Standard (default): Standard throughput Provisioned: preset throughput.
     */
    @JvmName("gumpnotmqalfiypp")
    public suspend fun throughputMode(`value`: Output<String>) {
        this.throughputMode = value
    }

    /**
     * @param value Zone Id, which is used to create file system resources to the specified zone.
     */
    @JvmName("bobnqsoaaknlkenp")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Redundancy mode of the file system. Value:
     * - LRS (default): Local redundancy.
     * - ZRS: Same-City redundancy. When ZRS is selected, zoneId is a string consisting of multiple zones that are expected to be redundant in the same city, for example,  'zoneId1,zoneId2 '.
     */
    @JvmName("jiilffvgiaqgqtyh")
    public suspend fun dataRedundancyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataRedundancyType = mapped
    }

    /**
     * @param value
     */
    @JvmName("cvdaqattfxuthllh")
    public suspend fun dedicatedClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedClusterId = mapped
    }

    /**
     * @param value The description of the file system resource. No more than 32 characters in length.
     */
    @JvmName("jawaifmjagqonslg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The file system name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
     */
    @JvmName("sdbhgefojshsbcgo")
    public suspend fun fileSystemName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemName = mapped
    }

    /**
     * @param value Save set sequence number, the user selects the content of the specified sequence number in the Save set.
     */
    @JvmName("twwysnmtobrjdbmx")
    public suspend fun partitionNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionNumber = mapped
    }

    /**
     * @param value The protocol type.  Only HDFS(Hadoop Distributed File System) is supported.
     */
    @JvmName("eblunmrlmhwvdxhf")
    public suspend fun protocolType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value Provisioned throughput. This parameter is required when ThroughputMode is set to Provisioned. Unit: MB/s Value range: 1~5120.
     */
    @JvmName("mixbkgpbltunhumq")
    public suspend fun provisionedThroughputInMiBps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedThroughputInMiBps = mapped
    }

    /**
     * @param value File system capacity.  When the actual amount of data stored reaches the capacity of the file system, data cannot be written.  Unit: GiB.
     */
    @JvmName("usjcprvfctrevpor")
    public suspend fun spaceCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceCapacity = mapped
    }

    /**
     * @param value Save set identity, used to select a user-specified save set.
     */
    @JvmName("olciaombpibpajna")
    public suspend fun storageSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSetName = mapped
    }

    /**
     * @param value The storage media type. Value: STANDARD (default): STANDARD PERFORMANCE: PERFORMANCE type.
     */
    @JvmName("aiqwbgatwvojogbq")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value The throughput mode. Value: Standard (default): Standard throughput Provisioned: preset throughput.
     */
    @JvmName("wbusxyvrfpxxhogi")
    public suspend fun throughputMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughputMode = mapped
    }

    /**
     * @param value Zone Id, which is used to create file system resources to the specified zone.
     */
    @JvmName("pctabqurvhuatgvy")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): FileSystemArgs = FileSystemArgs(
        dataRedundancyType = dataRedundancyType,
        dedicatedClusterId = dedicatedClusterId,
        description = description,
        fileSystemName = fileSystemName,
        partitionNumber = partitionNumber,
        protocolType = protocolType,
        provisionedThroughputInMiBps = provisionedThroughputInMiBps,
        spaceCapacity = spaceCapacity,
        storageSetName = storageSetName,
        storageType = storageType,
        throughputMode = throughputMode,
        zoneId = zoneId,
    )
}
