@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MountPoint].
 */
@PulumiTagMarker
public class MountPointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MountPointArgs = MountPointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MountPointArgsBuilder.() -> Unit) {
        val builder = MountPointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MountPoint {
        val builtJavaResource = com.pulumi.alicloud.dfs.MountPoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MountPoint(builtJavaResource)
    }
}

/**
 * Provides a DFS Mount Point resource.
 * For information about DFS Mount Point and how to use it, see [What is Mount Point](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).
 * > **NOTE:** Available since v1.140.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.dfs.getZones({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.zoneId),
 * });
 * const defaultFileSystem = new alicloud.dfs.FileSystem("default", {
 *     storageType: _default.then(_default => _default.zones?.[0]?&#46;options?&#46;[0]?.storageType),
 *     zoneId: _default.then(_default => _default.zones?.[0]?.zoneId),
 *     protocolType: "HDFS",
 *     description: name,
 *     fileSystemName: name,
 *     throughputMode: "Provisioned",
 *     spaceCapacity: 1024,
 *     provisionedThroughputInMiBps: 512,
 * });
 * const defaultAccessGroup = new alicloud.dfs.AccessGroup("default", {
 *     accessGroupName: name,
 *     description: name,
 *     networkType: "VPC",
 * });
 * const defaultMountPoint = new alicloud.dfs.MountPoint("default", {
 *     description: name,
 *     vpcId: defaultNetwork.id,
 *     fileSystemId: defaultFileSystem.id,
 *     accessGroupId: defaultAccessGroup.id,
 *     networkType: "VPC",
 *     vswitchId: defaultSwitch.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.dfs.get_zones()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].zone_id)
 * default_file_system = alicloud.dfs.FileSystem("default",
 *     storage_type=default.zones[0]&#46;options[0].storage_type,
 *     zone_id=default.zones[0].zone_id,
 *     protocol_type="HDFS",
 *     description=name,
 *     file_system_name=name,
 *     throughput_mode="Provisioned",
 *     space_capacity=1024,
 *     provisioned_throughput_in_mi_bps=512)
 * default_access_group = alicloud.dfs.AccessGroup("default",
 *     access_group_name=name,
 *     description=name,
 *     network_type="VPC")
 * default_mount_point = alicloud.dfs.MountPoint("default",
 *     description=name,
 *     vpc_id=default_network.id,
 *     file_system_id=default_file_system.id,
 *     access_group_id=default_access_group.id,
 *     network_type="VPC",
 *     vswitch_id=default_switch.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.Dfs.GetZones.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.ZoneId)),
 *     });
 *     var defaultFileSystem = new AliCloud.Dfs.FileSystem("default", new()
 *     {
 *         StorageType = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?&#46;Options[0]?.StorageType)),
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.ZoneId)),
 *         ProtocolType = "HDFS",
 *         Description = name,
 *         FileSystemName = name,
 *         ThroughputMode = "Provisioned",
 *         SpaceCapacity = 1024,
 *         ProvisionedThroughputInMiBps = 512,
 *     });
 *     var defaultAccessGroup = new AliCloud.Dfs.AccessGroup("default", new()
 *     {
 *         AccessGroupName = name,
 *         Description = name,
 *         NetworkType = "VPC",
 *     });
 *     var defaultMountPoint = new AliCloud.Dfs.MountPoint("default", new()
 *     {
 *         Description = name,
 *         VpcId = defaultNetwork.Id,
 *         FileSystemId = defaultFileSystem.Id,
 *         AccessGroupId = defaultAccessGroup.Id,
 *         NetworkType = "VPC",
 *         VswitchId = defaultSwitch.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dfs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := dfs.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].ZoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultFileSystem, err := dfs.NewFileSystem(ctx, "default", &dfs.FileSystemArgs{
 * 			StorageType:                  pulumi.String(_default.Zones[0]&#46;Options[0].StorageType),
 * 			ZoneId:                       pulumi.String(_default.Zones[0].ZoneId),
 * 			ProtocolType:                 pulumi.String("HDFS"),
 * 			Description:                  pulumi.String(name),
 * 			FileSystemName:               pulumi.String(name),
 * 			ThroughputMode:               pulumi.String("Provisioned"),
 * 			SpaceCapacity:                pulumi.Int(1024),
 * 			ProvisionedThroughputInMiBps: pulumi.Int(512),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAccessGroup, err := dfs.NewAccessGroup(ctx, "default", &dfs.AccessGroupArgs{
 * 			AccessGroupName: pulumi.String(name),
 * 			Description:     pulumi.String(name),
 * 			NetworkType:     pulumi.String("VPC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dfs.NewMountPoint(ctx, "default", &dfs.MountPointArgs{
 * 			Description:   pulumi.String(name),
 * 			VpcId:         defaultNetwork.ID(),
 * 			FileSystemId:  defaultFileSystem.ID(),
 * 			AccessGroupId: defaultAccessGroup.ID(),
 * 			NetworkType:   pulumi.String("VPC"),
 * 			VswitchId:     defaultSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dfs.DfsFunctions;
 * import com.pulumi.alicloud.dfs.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.dfs.FileSystem;
 * import com.pulumi.alicloud.dfs.FileSystemArgs;
 * import com.pulumi.alicloud.dfs.AccessGroup;
 * import com.pulumi.alicloud.dfs.AccessGroupArgs;
 * import com.pulumi.alicloud.dfs.MountPoint;
 * import com.pulumi.alicloud.dfs.MountPointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = DfsFunctions.getZones();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].zoneId())
 *             .build());
 *         var defaultFileSystem = new FileSystem("defaultFileSystem", FileSystemArgs.builder()
 *             .storageType(default_.zones()[0]&#46;options()[0].storageType())
 *             .zoneId(default_.zones()[0].zoneId())
 *             .protocolType("HDFS")
 *             .description(name)
 *             .fileSystemName(name)
 *             .throughputMode("Provisioned")
 *             .spaceCapacity("1024")
 *             .provisionedThroughputInMiBps("512")
 *             .build());
 *         var defaultAccessGroup = new AccessGroup("defaultAccessGroup", AccessGroupArgs.builder()
 *             .accessGroupName(name)
 *             .description(name)
 *             .networkType("VPC")
 *             .build());
 *         var defaultMountPoint = new MountPoint("defaultMountPoint", MountPointArgs.builder()
 *             .description(name)
 *             .vpcId(defaultNetwork.id())
 *             .fileSystemId(defaultFileSystem.id())
 *             .accessGroupId(defaultAccessGroup.id())
 *             .networkType("VPC")
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].zoneId}
 *   defaultFileSystem:
 *     type: alicloud:dfs:FileSystem
 *     name: default
 *     properties:
 *       storageType: ${default.zones[0]&#46;options[0].storageType}
 *       zoneId: ${default.zones[0].zoneId}
 *       protocolType: HDFS
 *       description: ${name}
 *       fileSystemName: ${name}
 *       throughputMode: Provisioned
 *       spaceCapacity: '1024'
 *       provisionedThroughputInMiBps: '512'
 *   defaultAccessGroup:
 *     type: alicloud:dfs:AccessGroup
 *     name: default
 *     properties:
 *       accessGroupName: ${name}
 *       description: ${name}
 *       networkType: VPC
 *   defaultMountPoint:
 *     type: alicloud:dfs:MountPoint
 *     name: default
 *     properties:
 *       description: ${name}
 *       vpcId: ${defaultNetwork.id}
 *       fileSystemId: ${defaultFileSystem.id}
 *       accessGroupId: ${defaultAccessGroup.id}
 *       networkType: VPC
 *       vswitchId: ${defaultSwitch.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:dfs:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DFS Mount Point can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dfs/mountPoint:MountPoint example <file_system_id>:<mount_point_id>
 * ```
 */
public class MountPoint internal constructor(
    override val javaResource: com.pulumi.alicloud.dfs.MountPoint,
) : KotlinCustomResource(javaResource, MountPointMapper) {
    /**
     * The id of the permission group associated with the Mount point, which is used to set the access permissions of the Mount point.
     */
    public val accessGroupId: Output<String>
        get() = javaResource.accessGroupId().applyValue({ args0 -> args0 })

    /**
     * The mount point alias prefix, which specifies the mount point alias prefix.
     */
    public val aliasPrefix: Output<String>?
        get() = javaResource.aliasPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The creation time of the Mount point resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the Mount point.  No more than 32 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique file system identifier, used to retrieve specified file system resources.
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })

    /**
     * The unique identifier of the Mount point, which is used to retrieve the specified mount point resources.
     */
    public val mountPointId: Output<String>
        get() = javaResource.mountPointId().applyValue({ args0 -> args0 })

    /**
     * The network type of the Mount point.  Only VPC (VPC) is supported.
     */
    public val networkType: Output<String>
        get() = javaResource.networkType().applyValue({ args0 -> args0 })

    /**
     * Mount point status. Value: Inactive: Disable mount points Active: Activate the mount point.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC. Specifies the VPC environment to which the mount point belongs.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * VSwitch ID, which specifies the VSwitch resource used to create the mount point.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object MountPointMapper : ResourceMapper<MountPoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dfs.MountPoint::class == javaResource::class

    override fun map(javaResource: Resource): MountPoint = MountPoint(
        javaResource as
            com.pulumi.alicloud.dfs.MountPoint,
    )
}

/**
 * @see [MountPoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MountPoint].
 */
public suspend fun mountPoint(name: String, block: suspend MountPointResourceBuilder.() -> Unit): MountPoint {
    val builder = MountPointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MountPoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mountPoint(name: String): MountPoint {
    val builder = MountPointResourceBuilder()
    builder.name(name)
    return builder.build()
}
