@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin

import com.pulumi.alicloud.dfs.MountPointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DFS Mount Point resource.
 * For information about DFS Mount Point and how to use it, see [What is Mount Point](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).
 * > **NOTE:** Available since v1.140.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.dfs.getZones({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.zoneId),
 * });
 * const defaultFileSystem = new alicloud.dfs.FileSystem("default", {
 *     storageType: _default.then(_default => _default.zones?.[0]?&#46;options?&#46;[0]?.storageType),
 *     zoneId: _default.then(_default => _default.zones?.[0]?.zoneId),
 *     protocolType: "HDFS",
 *     description: name,
 *     fileSystemName: name,
 *     throughputMode: "Provisioned",
 *     spaceCapacity: 1024,
 *     provisionedThroughputInMiBps: 512,
 * });
 * const defaultAccessGroup = new alicloud.dfs.AccessGroup("default", {
 *     accessGroupName: name,
 *     description: name,
 *     networkType: "VPC",
 * });
 * const defaultMountPoint = new alicloud.dfs.MountPoint("default", {
 *     description: name,
 *     vpcId: defaultNetwork.id,
 *     fileSystemId: defaultFileSystem.id,
 *     accessGroupId: defaultAccessGroup.id,
 *     networkType: "VPC",
 *     vswitchId: defaultSwitch.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.dfs.get_zones()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0].zone_id)
 * default_file_system = alicloud.dfs.FileSystem("default",
 *     storage_type=default.zones[0]&#46;options[0].storage_type,
 *     zone_id=default.zones[0].zone_id,
 *     protocol_type="HDFS",
 *     description=name,
 *     file_system_name=name,
 *     throughput_mode="Provisioned",
 *     space_capacity=1024,
 *     provisioned_throughput_in_mi_bps=512)
 * default_access_group = alicloud.dfs.AccessGroup("default",
 *     access_group_name=name,
 *     description=name,
 *     network_type="VPC")
 * default_mount_point = alicloud.dfs.MountPoint("default",
 *     description=name,
 *     vpc_id=default_network.id,
 *     file_system_id=default_file_system.id,
 *     access_group_id=default_access_group.id,
 *     network_type="VPC",
 *     vswitch_id=default_switch.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.Dfs.GetZones.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.ZoneId)),
 *     });
 *     var defaultFileSystem = new AliCloud.Dfs.FileSystem("default", new()
 *     {
 *         StorageType = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?&#46;Options[0]?.StorageType)),
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.ZoneId)),
 *         ProtocolType = "HDFS",
 *         Description = name,
 *         FileSystemName = name,
 *         ThroughputMode = "Provisioned",
 *         SpaceCapacity = 1024,
 *         ProvisionedThroughputInMiBps = 512,
 *     });
 *     var defaultAccessGroup = new AliCloud.Dfs.AccessGroup("default", new()
 *     {
 *         AccessGroupName = name,
 *         Description = name,
 *         NetworkType = "VPC",
 *     });
 *     var defaultMountPoint = new AliCloud.Dfs.MountPoint("default", new()
 *     {
 *         Description = name,
 *         VpcId = defaultNetwork.Id,
 *         FileSystemId = defaultFileSystem.Id,
 *         AccessGroupId = defaultAccessGroup.Id,
 *         NetworkType = "VPC",
 *         VswitchId = defaultSwitch.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dfs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := dfs.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].ZoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultFileSystem, err := dfs.NewFileSystem(ctx, "default", &dfs.FileSystemArgs{
 * 			StorageType:                  pulumi.String(_default.Zones[0]&#46;Options[0].StorageType),
 * 			ZoneId:                       pulumi.String(_default.Zones[0].ZoneId),
 * 			ProtocolType:                 pulumi.String("HDFS"),
 * 			Description:                  pulumi.String(name),
 * 			FileSystemName:               pulumi.String(name),
 * 			ThroughputMode:               pulumi.String("Provisioned"),
 * 			SpaceCapacity:                pulumi.Int(1024),
 * 			ProvisionedThroughputInMiBps: pulumi.Int(512),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAccessGroup, err := dfs.NewAccessGroup(ctx, "default", &dfs.AccessGroupArgs{
 * 			AccessGroupName: pulumi.String(name),
 * 			Description:     pulumi.String(name),
 * 			NetworkType:     pulumi.String("VPC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dfs.NewMountPoint(ctx, "default", &dfs.MountPointArgs{
 * 			Description:   pulumi.String(name),
 * 			VpcId:         defaultNetwork.ID(),
 * 			FileSystemId:  defaultFileSystem.ID(),
 * 			AccessGroupId: defaultAccessGroup.ID(),
 * 			NetworkType:   pulumi.String("VPC"),
 * 			VswitchId:     defaultSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dfs.DfsFunctions;
 * import com.pulumi.alicloud.dfs.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.dfs.FileSystem;
 * import com.pulumi.alicloud.dfs.FileSystemArgs;
 * import com.pulumi.alicloud.dfs.AccessGroup;
 * import com.pulumi.alicloud.dfs.AccessGroupArgs;
 * import com.pulumi.alicloud.dfs.MountPoint;
 * import com.pulumi.alicloud.dfs.MountPointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = DfsFunctions.getZones();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0].zoneId())
 *             .build());
 *         var defaultFileSystem = new FileSystem("defaultFileSystem", FileSystemArgs.builder()
 *             .storageType(default_.zones()[0]&#46;options()[0].storageType())
 *             .zoneId(default_.zones()[0].zoneId())
 *             .protocolType("HDFS")
 *             .description(name)
 *             .fileSystemName(name)
 *             .throughputMode("Provisioned")
 *             .spaceCapacity("1024")
 *             .provisionedThroughputInMiBps("512")
 *             .build());
 *         var defaultAccessGroup = new AccessGroup("defaultAccessGroup", AccessGroupArgs.builder()
 *             .accessGroupName(name)
 *             .description(name)
 *             .networkType("VPC")
 *             .build());
 *         var defaultMountPoint = new MountPoint("defaultMountPoint", MountPointArgs.builder()
 *             .description(name)
 *             .vpcId(defaultNetwork.id())
 *             .fileSystemId(defaultFileSystem.id())
 *             .accessGroupId(defaultAccessGroup.id())
 *             .networkType("VPC")
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0].zoneId}
 *   defaultFileSystem:
 *     type: alicloud:dfs:FileSystem
 *     name: default
 *     properties:
 *       storageType: ${default.zones[0]&#46;options[0].storageType}
 *       zoneId: ${default.zones[0].zoneId}
 *       protocolType: HDFS
 *       description: ${name}
 *       fileSystemName: ${name}
 *       throughputMode: Provisioned
 *       spaceCapacity: '1024'
 *       provisionedThroughputInMiBps: '512'
 *   defaultAccessGroup:
 *     type: alicloud:dfs:AccessGroup
 *     name: default
 *     properties:
 *       accessGroupName: ${name}
 *       description: ${name}
 *       networkType: VPC
 *   defaultMountPoint:
 *     type: alicloud:dfs:MountPoint
 *     name: default
 *     properties:
 *       description: ${name}
 *       vpcId: ${defaultNetwork.id}
 *       fileSystemId: ${defaultFileSystem.id}
 *       accessGroupId: ${defaultAccessGroup.id}
 *       networkType: VPC
 *       vswitchId: ${defaultSwitch.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:dfs:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DFS Mount Point can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dfs/mountPoint:MountPoint example <file_system_id>:<mount_point_id>
 * ```
 * @property accessGroupId The id of the permission group associated with the Mount point, which is used to set the access permissions of the Mount point.
 * @property aliasPrefix The mount point alias prefix, which specifies the mount point alias prefix.
 * @property description The description of the Mount point.  No more than 32 characters in length.
 * @property fileSystemId Unique file system identifier, used to retrieve specified file system resources.
 * @property networkType The network type of the Mount point.  Only VPC (VPC) is supported.
 * @property status Mount point status. Value: Inactive: Disable mount points Active: Activate the mount point.
 * @property vpcId The ID of the VPC. Specifies the VPC environment to which the mount point belongs.
 * @property vswitchId VSwitch ID, which specifies the VSwitch resource used to create the mount point.
 */
public data class MountPointArgs(
    public val accessGroupId: Output<String>? = null,
    public val aliasPrefix: Output<String>? = null,
    public val description: Output<String>? = null,
    public val fileSystemId: Output<String>? = null,
    public val networkType: Output<String>? = null,
    public val status: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dfs.MountPointArgs> {
    override fun toJava(): com.pulumi.alicloud.dfs.MountPointArgs =
        com.pulumi.alicloud.dfs.MountPointArgs.builder()
            .accessGroupId(accessGroupId?.applyValue({ args0 -> args0 }))
            .aliasPrefix(aliasPrefix?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .networkType(networkType?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MountPointArgs].
 */
@PulumiTagMarker
public class MountPointArgsBuilder internal constructor() {
    private var accessGroupId: Output<String>? = null

    private var aliasPrefix: Output<String>? = null

    private var description: Output<String>? = null

    private var fileSystemId: Output<String>? = null

    private var networkType: Output<String>? = null

    private var status: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The id of the permission group associated with the Mount point, which is used to set the access permissions of the Mount point.
     */
    @JvmName("upnpchvdqbltmcng")
    public suspend fun accessGroupId(`value`: Output<String>) {
        this.accessGroupId = value
    }

    /**
     * @param value The mount point alias prefix, which specifies the mount point alias prefix.
     */
    @JvmName("yogipmgihdxkdjyx")
    public suspend fun aliasPrefix(`value`: Output<String>) {
        this.aliasPrefix = value
    }

    /**
     * @param value The description of the Mount point.  No more than 32 characters in length.
     */
    @JvmName("inphjmlietwacuby")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Unique file system identifier, used to retrieve specified file system resources.
     */
    @JvmName("oojhgmlxvmxjqtbe")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value The network type of the Mount point.  Only VPC (VPC) is supported.
     */
    @JvmName("ayessncrtjirodvt")
    public suspend fun networkType(`value`: Output<String>) {
        this.networkType = value
    }

    /**
     * @param value Mount point status. Value: Inactive: Disable mount points Active: Activate the mount point.
     */
    @JvmName("rsugjmydrpuraewx")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The ID of the VPC. Specifies the VPC environment to which the mount point belongs.
     */
    @JvmName("csltqtocucrrwquj")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value VSwitch ID, which specifies the VSwitch resource used to create the mount point.
     */
    @JvmName("ffvucsqpqfkjggnw")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The id of the permission group associated with the Mount point, which is used to set the access permissions of the Mount point.
     */
    @JvmName("dgsbdyrhyfdsgfby")
    public suspend fun accessGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessGroupId = mapped
    }

    /**
     * @param value The mount point alias prefix, which specifies the mount point alias prefix.
     */
    @JvmName("olpyxcruwuvebala")
    public suspend fun aliasPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliasPrefix = mapped
    }

    /**
     * @param value The description of the Mount point.  No more than 32 characters in length.
     */
    @JvmName("octgvedynkarakcn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Unique file system identifier, used to retrieve specified file system resources.
     */
    @JvmName("rkcfiltgnpjagufh")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value The network type of the Mount point.  Only VPC (VPC) is supported.
     */
    @JvmName("amxripugmwdlgiuq")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value Mount point status. Value: Inactive: Disable mount points Active: Activate the mount point.
     */
    @JvmName("sjhuoegaxpydspbp")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The ID of the VPC. Specifies the VPC environment to which the mount point belongs.
     */
    @JvmName("jfdwlmxainppbtjq")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value VSwitch ID, which specifies the VSwitch resource used to create the mount point.
     */
    @JvmName("kubhgjyeohxjstcq")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): MountPointArgs = MountPointArgs(
        accessGroupId = accessGroupId,
        aliasPrefix = aliasPrefix,
        description = description,
        fileSystemId = fileSystemId,
        networkType = networkType,
        status = status,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
