@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin

import com.pulumi.alicloud.dfs.VscMountPointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DFS Vsc Mount Point resource. VSC mount point.
 * For information about DFS Vsc Mount Point and how to use it, see [What is Vsc Mount Point](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).
 * > **NOTE:** Available since v1.218.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const default = alicloud.dfs.getZones({});
 * const zoneId = _default.then(_default => _default.zones?.[0]?.zoneId);
 * const storageType = _default.then(_default => _default.zones?.[0]?&#46;options?&#46;[0]?.storageType);
 * const defaultFileSystem = new alicloud.dfs.FileSystem("default", {
 *     protocolType: "HDFS",
 *     description: name,
 *     fileSystemName: `${name}-${defaultInteger.result}`,
 *     spaceCapacity: 1024,
 *     throughputMode: "Provisioned",
 *     provisionedThroughputInMiBps: 512,
 *     storageType: storageType,
 *     zoneId: zoneId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default = alicloud.dfs.get_zones()
 * zone_id = default.zones[0].zone_id
 * storage_type = default.zones[0]&#46;options[0].storage_type
 * default_file_system = alicloud.dfs.FileSystem("default",
 *     protocol_type="HDFS",
 *     description=name,
 *     file_system_name=f"{name}-{default_integer['result']}",
 *     space_capacity=1024,
 *     throughput_mode="Provisioned",
 *     provisioned_throughput_in_mi_bps=512,
 *     storage_type=storage_type,
 *     zone_id=zone_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var @default = AliCloud.Dfs.GetZones.Invoke();
 *     var zoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.ZoneId));
 *     var storageType = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?&#46;Options[0]?.StorageType));
 *     var defaultFileSystem = new AliCloud.Dfs.FileSystem("default", new()
 *     {
 *         ProtocolType = "HDFS",
 *         Description = name,
 *         FileSystemName = $"{name}-{defaultInteger.Result}",
 *         SpaceCapacity = 1024,
 *         ThroughputMode = "Provisioned",
 *         ProvisionedThroughputInMiBps = 512,
 *         StorageType = storageType,
 *         ZoneId = zoneId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dfs"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := dfs.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		zoneId := _default.Zones[0].ZoneId
 * 		storageType := _default.Zones[0]&#46;Options[0].StorageType
 * 		_, err = dfs.NewFileSystem(ctx, "default", &dfs.FileSystemArgs{
 * 			ProtocolType:                 pulumi.String("HDFS"),
 * 			Description:                  pulumi.String(name),
 * 			FileSystemName:               pulumi.Sprintf("%v-%v", name, defaultInteger.Result),
 * 			SpaceCapacity:                pulumi.Int(1024),
 * 			ThroughputMode:               pulumi.String("Provisioned"),
 * 			ProvisionedThroughputInMiBps: pulumi.Int(512),
 * 			StorageType:                  pulumi.String(storageType),
 * 			ZoneId:                       pulumi.String(zoneId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.dfs.DfsFunctions;
 * import com.pulumi.alicloud.dfs.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.dfs.FileSystem;
 * import com.pulumi.alicloud.dfs.FileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var default = DfsFunctions.getZones();
 *         final var zoneId = default_.zones()[0].zoneId();
 *         final var storageType = default_.zones()[0]&#46;options()[0].storageType();
 *         var defaultFileSystem = new FileSystem("defaultFileSystem", FileSystemArgs.builder()
 *             .protocolType("HDFS")
 *             .description(name)
 *             .fileSystemName(String.format("%s-%s", name,defaultInteger.result()))
 *             .spaceCapacity("1024")
 *             .throughputMode("Provisioned")
 *             .provisionedThroughputInMiBps("512")
 *             .storageType(storageType)
 *             .zoneId(zoneId)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultFileSystem:
 *     type: alicloud:dfs:FileSystem
 *     name: default
 *     properties:
 *       protocolType: HDFS
 *       description: ${name}
 *       fileSystemName: ${name}-${defaultInteger.result}
 *       spaceCapacity: '1024'
 *       throughputMode: Provisioned
 *       provisionedThroughputInMiBps: '512'
 *       storageType: ${storageType}
 *       zoneId: ${zoneId}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:dfs:getZones
 *       Arguments: {}
 *   zoneId: ${default.zones[0].zoneId}
 *   storageType: ${default.zones[0]&#46;options[0].storageType}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DFS Vsc Mount Point can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dfs/vscMountPoint:VscMountPoint example <file_system_id>:<mount_point_id>
 * ```
 * @property aliasPrefix Mount point alias prefix, which is used as the prefix for generating VSC mount point aliases.
 * @property description The description of the Mount point.  The length is 0 to 100 characters.
 * @property fileSystemId The ID of the HDFS file system resource associated with the VSC mount point.
 */
public data class VscMountPointArgs(
    public val aliasPrefix: Output<String>? = null,
    public val description: Output<String>? = null,
    public val fileSystemId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dfs.VscMountPointArgs> {
    override fun toJava(): com.pulumi.alicloud.dfs.VscMountPointArgs =
        com.pulumi.alicloud.dfs.VscMountPointArgs.builder()
            .aliasPrefix(aliasPrefix?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VscMountPointArgs].
 */
@PulumiTagMarker
public class VscMountPointArgsBuilder internal constructor() {
    private var aliasPrefix: Output<String>? = null

    private var description: Output<String>? = null

    private var fileSystemId: Output<String>? = null

    /**
     * @param value Mount point alias prefix, which is used as the prefix for generating VSC mount point aliases.
     */
    @JvmName("eufbblysplisrdae")
    public suspend fun aliasPrefix(`value`: Output<String>) {
        this.aliasPrefix = value
    }

    /**
     * @param value The description of the Mount point.  The length is 0 to 100 characters.
     */
    @JvmName("kanbilhhjjdbvjpe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the HDFS file system resource associated with the VSC mount point.
     */
    @JvmName("oleeefvmekhhtgnv")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value Mount point alias prefix, which is used as the prefix for generating VSC mount point aliases.
     */
    @JvmName("evhusiesdwdhihvu")
    public suspend fun aliasPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliasPrefix = mapped
    }

    /**
     * @param value The description of the Mount point.  The length is 0 to 100 characters.
     */
    @JvmName("plpjauanbkuuyefa")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the HDFS file system resource associated with the VSC mount point.
     */
    @JvmName("ctjepwlgjeunvclf")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    internal fun build(): VscMountPointArgs = VscMountPointArgs(
        aliasPrefix = aliasPrefix,
        description = description,
        fileSystemId = fileSystemId,
    )
}
