@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin.inputs

import com.pulumi.alicloud.dfs.inputs.GetAccessGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccessGroups.
 * @property ids A list of Access Group IDs.
 * @property limit
 * @property nameRegex A regex string to filter results by Access Group name.
 * @property orderBy
 * @property orderType
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property startOffset
 */
public data class GetAccessGroupsPlainArgs(
    public val ids: List<String>? = null,
    public val limit: Int? = null,
    public val nameRegex: String? = null,
    public val orderBy: String? = null,
    public val orderType: String? = null,
    public val outputFile: String? = null,
    public val startOffset: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dfs.inputs.GetAccessGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dfs.inputs.GetAccessGroupsPlainArgs =
        com.pulumi.alicloud.dfs.inputs.GetAccessGroupsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .limit(limit?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .orderBy(orderBy?.let({ args0 -> args0 }))
            .orderType(orderType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .startOffset(startOffset?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetAccessGroupsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var limit: Int? = null

    private var nameRegex: String? = null

    private var orderBy: String? = null

    private var orderType: String? = null

    private var outputFile: String? = null

    private var startOffset: Int? = null

    /**
     * @param value A list of Access Group IDs.
     */
    @JvmName("rfnykplumumkmxix")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Access Group IDs.
     */
    @JvmName("obeorenwfgdklehj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("guijyoeorpxxxsdk")
    public suspend fun limit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.limit = mapped
    }

    /**
     * @param value A regex string to filter results by Access Group name.
     */
    @JvmName("kpukbhuaxbxfvoer")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("tkxqtssurekuttkc")
    public suspend fun orderBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderBy = mapped
    }

    /**
     * @param value
     */
    @JvmName("bfbxvfhoyvfmwjip")
    public suspend fun orderType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("woexlwqonjomasjq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("pefakghoirjxoksf")
    public suspend fun startOffset(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startOffset = mapped
    }

    internal fun build(): GetAccessGroupsPlainArgs = GetAccessGroupsPlainArgs(
        ids = ids,
        limit = limit,
        nameRegex = nameRegex,
        orderBy = orderBy,
        orderType = orderType,
        outputFile = outputFile,
        startOffset = startOffset,
    )
}
