@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin.inputs

import com.pulumi.alicloud.dfs.inputs.GetAccessRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccessRules.
 * @property accessGroupId The resource ID of the Access Group.
 * @property ids A list of Access Rule IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetAccessRulesPlainArgs(
    public val accessGroupId: String,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dfs.inputs.GetAccessRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dfs.inputs.GetAccessRulesPlainArgs =
        com.pulumi.alicloud.dfs.inputs.GetAccessRulesPlainArgs.builder()
            .accessGroupId(accessGroupId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessRulesPlainArgs].
 */
@PulumiTagMarker
public class GetAccessRulesPlainArgsBuilder internal constructor() {
    private var accessGroupId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value The resource ID of the Access Group.
     */
    @JvmName("etwkekrwjnvqkrlp")
    public suspend fun accessGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accessGroupId = mapped
    }

    /**
     * @param value A list of Access Rule IDs.
     */
    @JvmName("mvmvbralaibibpsd")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Access Rule IDs.
     */
    @JvmName("otfyplevgfiwujqg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nlhxqvcwnmqlhsab")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetAccessRulesPlainArgs = GetAccessRulesPlainArgs(
        accessGroupId = accessGroupId ?: throw PulumiNullFieldException("accessGroupId"),
        ids = ids,
        outputFile = outputFile,
    )
}
