@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin.inputs

import com.pulumi.alicloud.dfs.inputs.GetFileSystemsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFileSystems.
 * @property ids A list of File System IDs.
 * @property nameRegex A regex string to filter results by File System name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetFileSystemsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dfs.inputs.GetFileSystemsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dfs.inputs.GetFileSystemsPlainArgs =
        com.pulumi.alicloud.dfs.inputs.GetFileSystemsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFileSystemsPlainArgs].
 */
@PulumiTagMarker
public class GetFileSystemsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of File System IDs.
     */
    @JvmName("soeigbopvyrcfagv")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of File System IDs.
     */
    @JvmName("jrxpchsmmxvfjnou")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by File System name.
     */
    @JvmName("ybphvqlpwebgrsfy")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bllfoitbcftgenbc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetFileSystemsPlainArgs = GetFileSystemsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
