@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin.inputs

import com.pulumi.alicloud.dfs.inputs.GetMountPointsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMountPoints.
 * @property fileSystemId The ID of the File System.
 * @property ids A list of Mount Point IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the Mount Point. Valid values: `Active`, `Inactive`.
 */
public data class GetMountPointsPlainArgs(
    public val fileSystemId: String,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dfs.inputs.GetMountPointsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dfs.inputs.GetMountPointsPlainArgs =
        com.pulumi.alicloud.dfs.inputs.GetMountPointsPlainArgs.builder()
            .fileSystemId(fileSystemId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMountPointsPlainArgs].
 */
@PulumiTagMarker
public class GetMountPointsPlainArgsBuilder internal constructor() {
    private var fileSystemId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the File System.
     */
    @JvmName("rkmookwdhooesmmi")
    public suspend fun fileSystemId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fileSystemId = mapped
    }

    /**
     * @param value A list of Mount Point IDs.
     */
    @JvmName("gduclulvxidnadua")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Mount Point IDs.
     */
    @JvmName("acscyhephfafjffk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dclhhqvtcapyxtmk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the Mount Point. Valid values: `Active`, `Inactive`.
     */
    @JvmName("wioqioskwxdgadvl")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetMountPointsPlainArgs = GetMountPointsPlainArgs(
        fileSystemId = fileSystemId ?: throw PulumiNullFieldException("fileSystemId"),
        ids = ids,
        outputFile = outputFile,
        status = status,
    )
}
