@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessGroupId The length of `description` does not exceed 100 bytes.
 * @property accessGroupName The Name of Access Group. The length Of `access_group_name` does not exceed 100 bytes.
 * @property createTime The CreateTime of Access Group.
 * @property description The Description of Access Group. The length Of `description` does not exceed 100 bytes.
 * @property id The ID of the Access Group.
 * @property mountPointCount The Number of attached mountpoint.
 * @property networkType The NetworkType of Access Group. Valid values: `VPC`.
 * @property ruleCount The Number of access rule.
 */
public data class GetAccessGroupsGroup(
    public val accessGroupId: String,
    public val accessGroupName: String,
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val mountPointCount: Int,
    public val networkType: String,
    public val ruleCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dfs.outputs.GetAccessGroupsGroup): GetAccessGroupsGroup = GetAccessGroupsGroup(
            accessGroupId = javaType.accessGroupId(),
            accessGroupName = javaType.accessGroupName(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            mountPointCount = javaType.mountPointCount(),
            networkType = javaType.networkType(),
            ruleCount = javaType.ruleCount(),
        )
    }
}
