@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAccessGroups.
 * @property groups
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property limit
 * @property nameRegex
 * @property names
 * @property orderBy
 * @property orderType
 * @property outputFile
 * @property startOffset
 */
public data class GetAccessGroupsResult(
    public val groups: List<GetAccessGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val limit: Int? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val orderBy: String? = null,
    public val orderType: String? = null,
    public val outputFile: String? = null,
    public val startOffset: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dfs.outputs.GetAccessGroupsResult): GetAccessGroupsResult = GetAccessGroupsResult(
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dfs.kotlin.outputs.GetAccessGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            limit = javaType.limit().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            orderBy = javaType.orderBy().map({ args0 -> args0 }).orElse(null),
            orderType = javaType.orderType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            startOffset = javaType.startOffset().map({ args0 -> args0 }).orElse(null),
        )
    }
}
