@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAccessRules.
 * @property accessGroupId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property rules
 */
public data class GetAccessRulesResult(
    public val accessGroupId: String,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val rules: List<GetAccessRulesRule>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dfs.outputs.GetAccessRulesResult): GetAccessRulesResult = GetAccessRulesResult(
            accessGroupId = javaType.accessGroupId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dfs.kotlin.outputs.GetAccessRulesRule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
