@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessGroupId The resource ID of the Access Group.
 * @property accessRuleId The ID of the Access Rule.
 * @property createTime The created time of the Access Rule.
 * @property description The description of the Access Rule.
 * @property id The resource ID of Access Rule.
 * @property networkSegment The NetworkSegment of the Access Rule.
 * @property priority The priority of the Access Rule.
 * @property rwAccessType RWAccessType of the Access Rule. Valid values: `RDONLY`, `RDWR`.
 */
public data class GetAccessRulesRule(
    public val accessGroupId: String,
    public val accessRuleId: String,
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val networkSegment: String,
    public val priority: Int,
    public val rwAccessType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dfs.outputs.GetAccessRulesRule): GetAccessRulesRule = GetAccessRulesRule(
            accessGroupId = javaType.accessGroupId(),
            accessRuleId = javaType.accessRuleId(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            networkSegment = javaType.networkSegment(),
            priority = javaType.priority(),
            rwAccessType = javaType.rwAccessType(),
        )
    }
}
