@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The creation time of the File system.
 * @property description The description of the File system.
 * @property fileSystemId The ID of the File System.
 * @property fileSystemName The name of the File system.
 * @property id The ID of the File System.
 * @property mountPointCount The number of Mount points.
 * @property numberOfDirectories The number of directories.
 * @property numberOfFiles The number of files.
 * @property protocolType The protocol type. Valid values: `HDFS`.
 * @property provisionedThroughputInMiBps The preset throughput of the File system. Valid values: `1` to `1024`, Unit: MB/s.
 * @property spaceCapacity The capacity budget of the File system.
 * @property storagePackageId Storage package Id.
 * @property storageType The storage specifications of the File system. Valid values: `PERFORMANCE`, `STANDARD`.
 * @property throughputMode The throughput mode of the File system. Valid values: `Provisioned`, `Standard`.
 * @property usedSpaceSize The used space of the File system.
 * @property zoneId The zone ID of the File system.
 */
public data class GetFileSystemsSystem(
    public val createTime: String,
    public val description: String,
    public val fileSystemId: String,
    public val fileSystemName: String,
    public val id: String,
    public val mountPointCount: Int,
    public val numberOfDirectories: Int,
    public val numberOfFiles: Int,
    public val protocolType: String,
    public val provisionedThroughputInMiBps: Int,
    public val spaceCapacity: Int,
    public val storagePackageId: String,
    public val storageType: String,
    public val throughputMode: String,
    public val usedSpaceSize: Double,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dfs.outputs.GetFileSystemsSystem): GetFileSystemsSystem = GetFileSystemsSystem(
            createTime = javaType.createTime(),
            description = javaType.description(),
            fileSystemId = javaType.fileSystemId(),
            fileSystemName = javaType.fileSystemName(),
            id = javaType.id(),
            mountPointCount = javaType.mountPointCount(),
            numberOfDirectories = javaType.numberOfDirectories(),
            numberOfFiles = javaType.numberOfFiles(),
            protocolType = javaType.protocolType(),
            provisionedThroughputInMiBps = javaType.provisionedThroughputInMiBps(),
            spaceCapacity = javaType.spaceCapacity(),
            storagePackageId = javaType.storagePackageId(),
            storageType = javaType.storageType(),
            throughputMode = javaType.throughputMode(),
            usedSpaceSize = javaType.usedSpaceSize(),
            zoneId = javaType.zoneId(),
        )
    }
}
