@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessGroupId The ID of the Access Group.
 * @property createTime The created time of the Mount Point.
 * @property description The description of the Mount Point.
 * @property fileSystemId The ID of the File System.
 * @property id The ID of the Mount Point.
 * @property mountPointDomain The domain name of the Mount Point.
 * @property mountPointId The ID of the Mount Point.
 * @property networkType The network type of the Mount Point. Valid values: `VPC`.
 * @property status The status of the Mount Point. Valid values: `Active`, `Inactive`.
 * @property vpcId The ID of the VPC network.
 * @property vswitchId The vswitch id.
 */
public data class GetMountPointsPoint(
    public val accessGroupId: String,
    public val createTime: String,
    public val description: String,
    public val fileSystemId: String,
    public val id: String,
    public val mountPointDomain: String,
    public val mountPointId: String,
    public val networkType: String,
    public val status: String,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dfs.outputs.GetMountPointsPoint): GetMountPointsPoint = GetMountPointsPoint(
            accessGroupId = javaType.accessGroupId(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            fileSystemId = javaType.fileSystemId(),
            id = javaType.id(),
            mountPointDomain = javaType.mountPointDomain(),
            mountPointId = javaType.mountPointId(),
            networkType = javaType.networkType(),
            status = javaType.status(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
