@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getMountPoints.
 * @property fileSystemId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property points
 * @property status
 */
public data class GetMountPointsResult(
    public val fileSystemId: String,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val points: List<GetMountPointsPoint>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dfs.outputs.GetMountPointsResult): GetMountPointsResult = GetMountPointsResult(
            fileSystemId = javaType.fileSystemId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            points = javaType.points().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dfs.kotlin.outputs.GetMountPointsPoint.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
