@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property protocolType The protocol type. Valid values: `HDFS`.
 * @property storageType The storage specifications of the File system. Valid values: `PERFORMANCE`, `STANDARD`.
 */
public data class GetZonesZoneOption(
    public val protocolType: String,
    public val storageType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dfs.outputs.GetZonesZoneOption): GetZonesZoneOption = GetZonesZoneOption(
            protocolType = javaType.protocolType(),
            storageType = javaType.storageType(),
        )
    }
}
