@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property instanceId The ID of the ECS instance to which the HDFS file system is mounted.
 * @property status The status of the ECS instance on which the HDFS file system is mounted.
 * @property vscs The VSC list of mounted HDFS file systems.
 */
public data class VscMountPointInstance(
    public val instanceId: String? = null,
    public val status: String? = null,
    public val vscs: List<VscMountPointInstanceVsc>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dfs.outputs.VscMountPointInstance): VscMountPointInstance = VscMountPointInstance(
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vscs = javaType.vscs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dfs.kotlin.outputs.VscMountPointInstanceVsc.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
