@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dfs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property vscId VSC Channel primary key representation, used to retrieve the specified VSC Channel.
 * @property vscStatus VSC Mount status.
 * @property vscType The VSC type.
 */
public data class VscMountPointInstanceVsc(
    public val vscId: String? = null,
    public val vscStatus: String? = null,
    public val vscType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dfs.outputs.VscMountPointInstanceVsc): VscMountPointInstanceVsc = VscMountPointInstanceVsc(
            vscId = javaType.vscId().map({ args0 -> args0 }).orElse(null),
            vscStatus = javaType.vscStatus().map({ args0 -> args0 }).orElse(null),
            vscType = javaType.vscType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
