@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.directmail.kotlin

import com.pulumi.alicloud.directmail.DirectmailFunctions.getDomainsPlain
import com.pulumi.alicloud.directmail.DirectmailFunctions.getMailAddressesPlain
import com.pulumi.alicloud.directmail.DirectmailFunctions.getReceiversPlain
import com.pulumi.alicloud.directmail.DirectmailFunctions.getTagsPlain
import com.pulumi.alicloud.directmail.kotlin.inputs.GetDomainsPlainArgs
import com.pulumi.alicloud.directmail.kotlin.inputs.GetDomainsPlainArgsBuilder
import com.pulumi.alicloud.directmail.kotlin.inputs.GetMailAddressesPlainArgs
import com.pulumi.alicloud.directmail.kotlin.inputs.GetMailAddressesPlainArgsBuilder
import com.pulumi.alicloud.directmail.kotlin.inputs.GetReceiversPlainArgs
import com.pulumi.alicloud.directmail.kotlin.inputs.GetReceiversPlainArgsBuilder
import com.pulumi.alicloud.directmail.kotlin.inputs.GetTagsPlainArgs
import com.pulumi.alicloud.directmail.kotlin.inputs.GetTagsPlainArgsBuilder
import com.pulumi.alicloud.directmail.kotlin.outputs.GetDomainsResult
import com.pulumi.alicloud.directmail.kotlin.outputs.GetMailAddressesResult
import com.pulumi.alicloud.directmail.kotlin.outputs.GetReceiversResult
import com.pulumi.alicloud.directmail.kotlin.outputs.GetTagsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.directmail.kotlin.outputs.GetDomainsResult.Companion.toKotlin as getDomainsResultToKotlin
import com.pulumi.alicloud.directmail.kotlin.outputs.GetMailAddressesResult.Companion.toKotlin as getMailAddressesResultToKotlin
import com.pulumi.alicloud.directmail.kotlin.outputs.GetReceiversResult.Companion.toKotlin as getReceiversResultToKotlin
import com.pulumi.alicloud.directmail.kotlin.outputs.GetTagsResult.Companion.toKotlin as getTagsResultToKotlin

public object DirectmailFunctions {
    /**
     * This data source provides the Direct Mail Domains of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.134.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "terraform-example.pop.com";
     * const _default = new alicloud.directmail.Domain("default", {domainName: name});
     * const ids = alicloud.directmail.getDomainsOutput({
     *     ids: [_default&#46;id],
     * });
     * export const directMailDomainsId0 = ids.apply(ids => ids.domains?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "terraform-example.pop.com"
     * default = alicloud.directmail.Domain("default", domain_name=name)
     * ids = alicloud.directmail.get_domains_output(ids=[default&#46;id])
     * pulumi.export("directMailDomainsId0", ids.domains[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "terraform-example.pop.com";
     *     var @default = new AliCloud.DirectMail.Domain("default", new()
     *     {
     *         DomainName = name,
     *     });
     *     var ids = AliCloud.DirectMail.GetDomains.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             @default.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["directMailDomainsId0"] = ids&#46;Apply(getDomainsResult => getDomainsResult&#46;Domains[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/directmail"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "terraform-example.pop.com"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_, err := directmail.NewDomain(ctx, "default", &directmail.DomainArgs{
     * 			DomainName: pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids := directmail.GetDomainsOutput(ctx, directmail.GetDomainsOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				_default.ID(),
     * 			},
     * 		}, nil)
     * 		ctx.Export("directMailDomainsId0", ids.ApplyT(func(ids directmail.GetDomainsResult) (*string, error) {
     * 			return &ids.Domains[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.directmail.Domain;
     * import com.pulumi.alicloud.directmail.DomainArgs;
     * import com.pulumi.alicloud.directmail.DirectmailFunctions;
     * import com.pulumi.alicloud.directmail.inputs.GetDomainsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("terraform-example.pop.com");
     *         var default_ = new Domain("default", DomainArgs.builder()
     *             .domainName(name)
     *             .build());
     *         final var ids = DirectmailFunctions.getDomains(GetDomainsArgs.builder()
     *             .ids(default_.id())
     *             .build());
     *         ctx.export("directMailDomainsId0", ids.applyValue(getDomainsResult -> getDomainsResult).applyValue(ids -> ids.applyValue(getDomainsResult -> getDomainsResult.domains()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: terraform-example.pop.com
     * resources:
     *   default:
     *     type: alicloud:directmail:Domain
     *     properties:
     *       domainName: ${name}
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:directmail:getDomains
     *       Arguments:
     *         ids:
     *           - ${default.id}
     * outputs:
     *   directMailDomainsId0: ${ids.domains[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDomains.
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: GetDomainsPlainArgs): GetDomainsResult =
        getDomainsResultToKotlin(getDomainsPlain(argument.toJava()).await())

    /**
     * @see [getDomains].
     * @param enableDetails Whether to query the detailed list of resource attributes. Default value: `false`.
     * @param ids A list of Domain IDs.
     * @param keyWord The domain name. It must be 1 to 50 characters in length and can contain digits, letters, periods (.), and hyphens (-).
     * @param nameRegex A regex string to filter results by Domain name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the domain name. Valid values:
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        keyWord: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetDomainsResult {
        val argument = GetDomainsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            keyWord = keyWord,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getDomainsResultToKotlin(getDomainsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomains].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;directmail&#46;kotlin&#46;inputs&#46;GetDomainsPlainArgs].
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: suspend GetDomainsPlainArgsBuilder.() -> Unit): GetDomainsResult {
        val builder = GetDomainsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainsResultToKotlin(getDomainsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Direct Mail Mail Addresses of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.134.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.directmail.getMailAddresses({
     *     ids: ["example_id"],
     * });
     * export const directMailMailAddressId1 = ids.then(ids => ids.addresses?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.directmail.get_mail_addresses(ids=["example_id"])
     * pulumi.export("directMailMailAddressId1", ids.addresses[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.DirectMail.GetMailAddresses.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["directMailMailAddressId1"] = ids&#46;Apply(getMailAddressesResult => getMailAddressesResult&#46;Addresses[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/directmail"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := directmail.GetMailAddresses(ctx, &directmail.GetMailAddressesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("directMailMailAddressId1", ids.Addresses[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.directmail.DirectmailFunctions;
     * import com.pulumi.alicloud.directmail.inputs.GetMailAddressesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DirectmailFunctions.getMailAddresses(GetMailAddressesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("directMailMailAddressId1", ids.applyValue(getMailAddressesResult -> getMailAddressesResult.addresses()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:directmail:getMailAddresses
     *       Arguments:
     *         ids:
     *           - example_id
     * outputs:
     *   directMailMailAddressId1: ${ids.addresses[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMailAddresses.
     * @return A collection of values returned by getMailAddresses.
     */
    public suspend fun getMailAddresses(argument: GetMailAddressesPlainArgs): GetMailAddressesResult =
        getMailAddressesResultToKotlin(getMailAddressesPlain(argument.toJava()).await())

    /**
     * @see [getMailAddresses].
     * @param ids A list of Mail Address IDs.
     * @param keyWord The key word about account email address.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param sendtype Account type. Valid values: `batch`, `trigger`.
     * @param status Account Status. Valid values: `0`, `1`. Freeze: 1, normal: 0.
     * @return A collection of values returned by getMailAddresses.
     */
    public suspend fun getMailAddresses(
        ids: List<String>? = null,
        keyWord: String? = null,
        outputFile: String? = null,
        sendtype: String? = null,
        status: String? = null,
    ): GetMailAddressesResult {
        val argument = GetMailAddressesPlainArgs(
            ids = ids,
            keyWord = keyWord,
            outputFile = outputFile,
            sendtype = sendtype,
            status = status,
        )
        return getMailAddressesResultToKotlin(getMailAddressesPlain(argument.toJava()).await())
    }

    /**
     * @see [getMailAddresses].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;directmail&#46;kotlin&#46;inputs&#46;GetMailAddressesPlainArgs].
     * @return A collection of values returned by getMailAddresses.
     */
    public suspend fun getMailAddresses(argument: suspend GetMailAddressesPlainArgsBuilder.() -> Unit): GetMailAddressesResult {
        val builder = GetMailAddressesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMailAddressesResultToKotlin(getMailAddressesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Direct Mail Receiverses of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.125.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.directmail.getReceivers({
     *     ids: ["ca73b1e4fb0df7c935a5097a****"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstDirectMailReceiversId = example.then(example => example.receiverses?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.directmail.get_receivers(ids=["ca73b1e4fb0df7c935a5097a****"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstDirectMailReceiversId", example.receiverses[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.DirectMail.GetReceivers.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "ca73b1e4fb0df7c935a5097a****",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstDirectMailReceiversId"] = example&#46;Apply(getReceiversResult => getReceiversResult&#46;Receiverses[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/directmail"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := directmail.LookupReceivers(ctx, &directmail.LookupReceiversArgs{
     * 			Ids: []string{
     * 				"ca73b1e4fb0df7c935a5097a****",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstDirectMailReceiversId", example.Receiverses[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.directmail.DirectmailFunctions;
     * import com.pulumi.alicloud.directmail.inputs.GetReceiversArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DirectmailFunctions.getReceivers(GetReceiversArgs.builder()
     *             .ids("ca73b1e4fb0df7c935a5097a****")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstDirectMailReceiversId", example.applyValue(getReceiversResult -> getReceiversResult.receiverses()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:directmail:getReceivers
     *       Arguments:
     *         ids:
     *           - ca73b1e4fb0df7c935a5097a****
     *         nameRegex: the_resource_name
     * outputs:
     *   firstDirectMailReceiversId: ${example.receiverses[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getReceivers.
     * @return A collection of values returned by getReceivers.
     */
    public suspend fun getReceivers(argument: GetReceiversPlainArgs): GetReceiversResult =
        getReceiversResultToKotlin(getReceiversPlain(argument.toJava()).await())

    /**
     * @see [getReceivers].
     * @param ids A list of Receivers IDs.
     * @param keyWord The key word.
     * @param nameRegex A regex string to filter results by Receivers name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid Values: `0` means uploading, `1` means upload completed.
     * @return A collection of values returned by getReceivers.
     */
    public suspend fun getReceivers(
        ids: List<String>? = null,
        keyWord: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: Int? = null,
    ): GetReceiversResult {
        val argument = GetReceiversPlainArgs(
            ids = ids,
            keyWord = keyWord,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getReceiversResultToKotlin(getReceiversPlain(argument.toJava()).await())
    }

    /**
     * @see [getReceivers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;directmail&#46;kotlin&#46;inputs&#46;GetReceiversPlainArgs].
     * @return A collection of values returned by getReceivers.
     */
    public suspend fun getReceivers(argument: suspend GetReceiversPlainArgsBuilder.() -> Unit): GetReceiversResult {
        val builder = GetReceiversPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReceiversResultToKotlin(getReceiversPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Direct Mail Tags of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.144.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.directmail.getTags({
     *     ids: ["example_id"],
     * });
     * export const directMailTagId1 = ids.then(ids => ids.tags?.[0]?.id);
     * const nameRegex = alicloud.directmail.getTags({
     *     nameRegex: "^my-Tag",
     * });
     * export const directMailTagId2 = nameRegex.then(nameRegex => nameRegex.tags?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.directmail.get_tags(ids=["example_id"])
     * pulumi.export("directMailTagId1", ids.tags[0].id)
     * name_regex = alicloud.directmail.get_tags(name_regex="^my-Tag")
     * pulumi.export("directMailTagId2", name_regex.tags[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.DirectMail.GetTags.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.DirectMail.GetTags.Invoke(new()
     *     {
     *         NameRegex = "^my-Tag",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["directMailTagId1"] = ids&#46;Apply(getTagsResult => getTagsResult&#46;Tags[0]?.Id),
     *         ["directMailTagId2"] = nameRegex&#46;Apply(getTagsResult => getTagsResult&#46;Tags[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/directmail"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := directmail.GetTags(ctx, &directmail.GetTagsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("directMailTagId1", ids.Tags[0].Id)
     * 		nameRegex, err := directmail.GetTags(ctx, &directmail.GetTagsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Tag"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("directMailTagId2", nameRegex.Tags[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.directmail.DirectmailFunctions;
     * import com.pulumi.alicloud.directmail.inputs.GetTagsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = DirectmailFunctions.getTags(GetTagsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("directMailTagId1", ids.applyValue(getTagsResult -> getTagsResult.tags()[0].id()));
     *         final var nameRegex = DirectmailFunctions.getTags(GetTagsArgs.builder()
     *             .nameRegex("^my-Tag")
     *             .build());
     *         ctx.export("directMailTagId2", nameRegex.applyValue(getTagsResult -> getTagsResult.tags()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:directmail:getTags
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:directmail:getTags
     *       Arguments:
     *         nameRegex: ^my-Tag
     * outputs:
     *   directMailTagId1: ${ids.tags[0].id}
     *   directMailTagId2: ${nameRegex.tags[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTags.
     * @return A collection of values returned by getTags.
     */
    public suspend fun getTags(argument: GetTagsPlainArgs): GetTagsResult =
        getTagsResultToKotlin(getTagsPlain(argument.toJava()).await())

    /**
     * @see [getTags].
     * @param ids A list of Tag IDs.
     * @param nameRegex A regex string to filter results by Tag name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getTags.
     */
    public suspend fun getTags(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetTagsResult {
        val argument = GetTagsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getTagsResultToKotlin(getTagsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTags].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;directmail&#46;kotlin&#46;inputs&#46;GetTagsPlainArgs].
     * @return A collection of values returned by getTags.
     */
    public suspend fun getTags(argument: suspend GetTagsPlainArgsBuilder.() -> Unit): GetTagsResult {
        val builder = GetTagsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTagsResultToKotlin(getTagsPlain(builtArgument.toJava()).await())
    }
}
