@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.directmail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MailAddress].
 */
@PulumiTagMarker
public class MailAddressResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MailAddressArgs = MailAddressArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MailAddressArgsBuilder.() -> Unit) {
        val builder = MailAddressArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MailAddress {
        val builtJavaResource = com.pulumi.alicloud.directmail.MailAddress(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MailAddress(builtJavaResource)
    }
}

/**
 * Provides a Direct Mail Mail Address resource.
 * For information about Direct Mail Mail Address and how to use it, see [What is Mail Address](https://www.alibabacloud.com/help/en/directmail/latest/set-up-sender-addresses).
 * > **NOTE:** Available since v1.134.0.
 * ## Import
 * Direct Mail Mail Address can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:directmail/mailAddress:MailAddress example <id>
 * ```
 */
public class MailAddress internal constructor(
    override val javaResource: com.pulumi.alicloud.directmail.MailAddress,
) : KotlinCustomResource(javaResource, MailAddressMapper) {
    /**
     * The sender address. The email address must be filled in the format of account@domain, and only lowercase letters or numbers can be used.
     */
    public val accountName: Output<String>
        get() = javaResource.accountName().applyValue({ args0 -> args0 })

    /**
     * Account password. The password must be length 10-20 string, contains numbers, uppercase letters, lowercase letters at the same time.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Return address.
     */
    public val replyAddress: Output<String>?
        get() = javaResource.replyAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Account type. Valid values: `batch`, `trigger`.
     */
    public val sendtype: Output<String>
        get() = javaResource.sendtype().applyValue({ args0 -> args0 })

    /**
     * Account Status freeze: 1, normal: 0.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object MailAddressMapper : ResourceMapper<MailAddress> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.directmail.MailAddress::class == javaResource::class

    override fun map(javaResource: Resource): MailAddress = MailAddress(
        javaResource as
            com.pulumi.alicloud.directmail.MailAddress,
    )
}

/**
 * @see [MailAddress].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MailAddress].
 */
public suspend fun mailAddress(name: String, block: suspend MailAddressResourceBuilder.() -> Unit): MailAddress {
    val builder = MailAddressResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MailAddress].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mailAddress(name: String): MailAddress {
    val builder = MailAddressResourceBuilder()
    builder.name(name)
    return builder.build()
}
