@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.directmail.kotlin

import com.pulumi.alicloud.directmail.MailAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Direct Mail Mail Address resource.
 * For information about Direct Mail Mail Address and how to use it, see [What is Mail Address](https://www.alibabacloud.com/help/en/directmail/latest/set-up-sender-addresses).
 * > **NOTE:** Available since v1.134.0.
 * ## Import
 * Direct Mail Mail Address can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:directmail/mailAddress:MailAddress example <id>
 * ```
 * @property accountName The sender address. The email address must be filled in the format of account@domain, and only lowercase letters or numbers can be used.
 * @property password Account password. The password must be length 10-20 string, contains numbers, uppercase letters, lowercase letters at the same time.
 * @property replyAddress Return address.
 * @property sendtype Account type. Valid values: `batch`, `trigger`.
 */
public data class MailAddressArgs(
    public val accountName: Output<String>? = null,
    public val password: Output<String>? = null,
    public val replyAddress: Output<String>? = null,
    public val sendtype: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.directmail.MailAddressArgs> {
    override fun toJava(): com.pulumi.alicloud.directmail.MailAddressArgs =
        com.pulumi.alicloud.directmail.MailAddressArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .replyAddress(replyAddress?.applyValue({ args0 -> args0 }))
            .sendtype(sendtype?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MailAddressArgs].
 */
@PulumiTagMarker
public class MailAddressArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var password: Output<String>? = null

    private var replyAddress: Output<String>? = null

    private var sendtype: Output<String>? = null

    /**
     * @param value The sender address. The email address must be filled in the format of account@domain, and only lowercase letters or numbers can be used.
     */
    @JvmName("yimdkltexrjouyas")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Account password. The password must be length 10-20 string, contains numbers, uppercase letters, lowercase letters at the same time.
     */
    @JvmName("cdentttyvfrdrtig")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Return address.
     */
    @JvmName("uxjcysnnmqfbfnow")
    public suspend fun replyAddress(`value`: Output<String>) {
        this.replyAddress = value
    }

    /**
     * @param value Account type. Valid values: `batch`, `trigger`.
     */
    @JvmName("bguunddgnreuyimr")
    public suspend fun sendtype(`value`: Output<String>) {
        this.sendtype = value
    }

    /**
     * @param value The sender address. The email address must be filled in the format of account@domain, and only lowercase letters or numbers can be used.
     */
    @JvmName("pkxphyyjivwlodxt")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Account password. The password must be length 10-20 string, contains numbers, uppercase letters, lowercase letters at the same time.
     */
    @JvmName("iwslsvikaselfehy")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Return address.
     */
    @JvmName("jeitrewiftoamgqm")
    public suspend fun replyAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replyAddress = mapped
    }

    /**
     * @param value Account type. Valid values: `batch`, `trigger`.
     */
    @JvmName("vixcbrlqgtultmes")
    public suspend fun sendtype(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendtype = mapped
    }

    internal fun build(): MailAddressArgs = MailAddressArgs(
        accountName = accountName,
        password = password,
        replyAddress = replyAddress,
        sendtype = sendtype,
    )
}
