@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.directmail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Receivers].
 */
@PulumiTagMarker
public class ReceiversResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReceiversArgs = ReceiversArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReceiversArgsBuilder.() -> Unit) {
        val builder = ReceiversArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Receivers {
        val builtJavaResource = com.pulumi.alicloud.directmail.Receivers(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Receivers(builtJavaResource)
    }
}

/**
 * Provides a Direct Mail Receivers resource.
 * For information about Direct Mail Receivers and how to use it, see [What is Direct Mail Receivers](https://www.alibabacloud.com/help/en/doc-detail/29414.htm).
 * > **NOTE:** Available since v1.125.0.
 * ## Import
 * Direct Mail Receivers can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:directmail/receivers:Receivers example <id>
 * ```
 */
public class Receivers internal constructor(
    override val javaResource: com.pulumi.alicloud.directmail.Receivers,
) : KotlinCustomResource(javaResource, ReceiversMapper) {
    /**
     * The description of receivers and 1-50 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The alias of receivers. Must email address and less than 30 characters in length.
     */
    public val receiversAlias: Output<String>
        get() = javaResource.receiversAlias().applyValue({ args0 -> args0 })

    /**
     * The name of the resource. The length that cannot be repeated is 1-30 characters.
     */
    public val receiversName: Output<String>
        get() = javaResource.receiversName().applyValue({ args0 -> args0 })

    /**
     * The status of the resource. `0` means uploading, `1` means upload completed.
     */
    public val status: Output<Int>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ReceiversMapper : ResourceMapper<Receivers> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.directmail.Receivers::class == javaResource::class

    override fun map(javaResource: Resource): Receivers = Receivers(
        javaResource as
            com.pulumi.alicloud.directmail.Receivers,
    )
}

/**
 * @see [Receivers].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Receivers].
 */
public suspend fun receivers(name: String, block: suspend ReceiversResourceBuilder.() -> Unit): Receivers {
    val builder = ReceiversResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Receivers].
 * @param name The _unique_ name of the resulting resource.
 */
public fun receivers(name: String): Receivers {
    val builder = ReceiversResourceBuilder()
    builder.name(name)
    return builder.build()
}
