@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.directmail.kotlin

import com.pulumi.alicloud.directmail.ReceiversArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Direct Mail Receivers resource.
 * For information about Direct Mail Receivers and how to use it, see [What is Direct Mail Receivers](https://www.alibabacloud.com/help/en/doc-detail/29414.htm).
 * > **NOTE:** Available since v1.125.0.
 * ## Import
 * Direct Mail Receivers can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:directmail/receivers:Receivers example <id>
 * ```
 * @property description The description of receivers and 1-50 characters in length.
 * @property receiversAlias The alias of receivers. Must email address and less than 30 characters in length.
 * @property receiversName The name of the resource. The length that cannot be repeated is 1-30 characters.
 */
public data class ReceiversArgs(
    public val description: Output<String>? = null,
    public val receiversAlias: Output<String>? = null,
    public val receiversName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.directmail.ReceiversArgs> {
    override fun toJava(): com.pulumi.alicloud.directmail.ReceiversArgs =
        com.pulumi.alicloud.directmail.ReceiversArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .receiversAlias(receiversAlias?.applyValue({ args0 -> args0 }))
            .receiversName(receiversName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReceiversArgs].
 */
@PulumiTagMarker
public class ReceiversArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var receiversAlias: Output<String>? = null

    private var receiversName: Output<String>? = null

    /**
     * @param value The description of receivers and 1-50 characters in length.
     */
    @JvmName("hixubmnlmpikunkb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The alias of receivers. Must email address and less than 30 characters in length.
     */
    @JvmName("tsguidmunbsntdxm")
    public suspend fun receiversAlias(`value`: Output<String>) {
        this.receiversAlias = value
    }

    /**
     * @param value The name of the resource. The length that cannot be repeated is 1-30 characters.
     */
    @JvmName("rxpweebindyihuxp")
    public suspend fun receiversName(`value`: Output<String>) {
        this.receiversName = value
    }

    /**
     * @param value The description of receivers and 1-50 characters in length.
     */
    @JvmName("mfxufhwqrmpkvxlp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The alias of receivers. Must email address and less than 30 characters in length.
     */
    @JvmName("klqbtrixhvgdxguc")
    public suspend fun receiversAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.receiversAlias = mapped
    }

    /**
     * @param value The name of the resource. The length that cannot be repeated is 1-30 characters.
     */
    @JvmName("xhayocijbtiqhutn")
    public suspend fun receiversName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.receiversName = mapped
    }

    internal fun build(): ReceiversArgs = ReceiversArgs(
        description = description,
        receiversAlias = receiversAlias,
        receiversName = receiversName,
    )
}
