@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.directmail.kotlin

import com.pulumi.alicloud.directmail.TagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Direct Mail Tag resource.
 * For information about Direct Mail Tag and how to use it, see [What is Tag](https://www.alibabacloud.com/help/en/directmail/latest/createtag).
 * > **NOTE:** Available since v1.144.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "example";
 * const example = new alicloud.directmail.Tag("example", {tagName: name});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "example"
 * example = alicloud.directmail.Tag("example", tag_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "example";
 *     var example = new AliCloud.DirectMail.Tag("example", new()
 *     {
 *         TagName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/directmail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := directmail.NewTag(ctx, "example", &directmail.TagArgs{
 * 			TagName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.directmail.Tag;
 * import com.pulumi.alicloud.directmail.TagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("example");
 *         var example = new Tag("example", TagArgs.builder()
 *             .tagName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: example
 * resources:
 *   example:
 *     type: alicloud:directmail:Tag
 *     properties:
 *       tagName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Direct Mail Tag can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:directmail/tag:Tag example <id>
 * ```
 * @property tagName The name of the tag. The name must be `1` to `50` characters in length, and can contain letters and digits.
 */
public data class TagArgs(
    public val tagName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.directmail.TagArgs> {
    override fun toJava(): com.pulumi.alicloud.directmail.TagArgs =
        com.pulumi.alicloud.directmail.TagArgs.builder()
            .tagName(tagName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagArgs].
 */
@PulumiTagMarker
public class TagArgsBuilder internal constructor() {
    private var tagName: Output<String>? = null

    /**
     * @param value The name of the tag. The name must be `1` to `50` characters in length, and can contain letters and digits.
     */
    @JvmName("ogkrkmhjysuqdcvu")
    public suspend fun tagName(`value`: Output<String>) {
        this.tagName = value
    }

    /**
     * @param value The name of the tag. The name must be `1` to `50` characters in length, and can contain letters and digits.
     */
    @JvmName("txgecdxaxwdmswca")
    public suspend fun tagName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagName = mapped
    }

    internal fun build(): TagArgs = TagArgs(
        tagName = tagName,
    )
}
