@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.directmail.kotlin.inputs

import com.pulumi.alicloud.directmail.inputs.GetDomainsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDomains.
 * @property enableDetails Whether to query the detailed list of resource attributes. Default value: `false`.
 * @property ids A list of Domain IDs.
 * @property keyWord The domain name. It must be 1 to 50 characters in length and can contain digits, letters, periods (.), and hyphens (-).
 * @property nameRegex A regex string to filter results by Domain name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the domain name. Valid values:
 */
public data class GetDomainsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val keyWord: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.directmail.inputs.GetDomainsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.directmail.inputs.GetDomainsPlainArgs =
        com.pulumi.alicloud.directmail.inputs.GetDomainsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyWord(keyWord?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainsPlainArgs].
 */
@PulumiTagMarker
public class GetDomainsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var keyWord: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value Whether to query the detailed list of resource attributes. Default value: `false`.
     */
    @JvmName("sgbxysodbscmwdeq")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Domain IDs.
     */
    @JvmName("bejiguxpugkpdcty")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Domain IDs.
     */
    @JvmName("mrqtslnbgekwksrf")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The domain name. It must be 1 to 50 characters in length and can contain digits, letters, periods (.), and hyphens (-).
     */
    @JvmName("wyavahpygchxqvpf")
    public suspend fun keyWord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyWord = mapped
    }

    /**
     * @param value A regex string to filter results by Domain name.
     */
    @JvmName("wwmsjjetwgjewkmo")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("oehkdwyumersmakv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the domain name. Valid values:
     */
    @JvmName("jfveihnwmsueyfgl")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetDomainsPlainArgs = GetDomainsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        keyWord = keyWord,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
