@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.directmail.kotlin.inputs

import com.pulumi.alicloud.directmail.inputs.GetMailAddressesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMailAddresses.
 * @property ids A list of Mail Address IDs.
 * @property keyWord The key word about account email address.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property sendtype Account type. Valid values: `batch`, `trigger`.
 * @property status Account Status. Valid values: `0`, `1`. Freeze: 1, normal: 0.
 */
public data class GetMailAddressesPlainArgs(
    public val ids: List<String>? = null,
    public val keyWord: String? = null,
    public val outputFile: String? = null,
    public val sendtype: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.directmail.inputs.GetMailAddressesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.directmail.inputs.GetMailAddressesPlainArgs =
        com.pulumi.alicloud.directmail.inputs.GetMailAddressesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyWord(keyWord?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .sendtype(sendtype?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMailAddressesPlainArgs].
 */
@PulumiTagMarker
public class GetMailAddressesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var keyWord: String? = null

    private var outputFile: String? = null

    private var sendtype: String? = null

    private var status: String? = null

    /**
     * @param value A list of Mail Address IDs.
     */
    @JvmName("irlrvdcrkhyyqujo")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Mail Address IDs.
     */
    @JvmName("qiwrmhjaowmffjou")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The key word about account email address.
     */
    @JvmName("pgfklnujbifvdtre")
    public suspend fun keyWord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyWord = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("thgnwsjcwfxqvqvt")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Account type. Valid values: `batch`, `trigger`.
     */
    @JvmName("luunwrhvynddybcw")
    public suspend fun sendtype(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sendtype = mapped
    }

    /**
     * @param value Account Status. Valid values: `0`, `1`. Freeze: 1, normal: 0.
     */
    @JvmName("unjmopboymidswnw")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetMailAddressesPlainArgs = GetMailAddressesPlainArgs(
        ids = ids,
        keyWord = keyWord,
        outputFile = outputFile,
        sendtype = sendtype,
        status = status,
    )
}
