@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.directmail.kotlin.inputs

import com.pulumi.alicloud.directmail.inputs.GetReceiversPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReceivers.
 * @property ids A list of Receivers IDs.
 * @property keyWord The key word.
 * @property nameRegex A regex string to filter results by Receivers name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid Values: `0` means uploading, `1` means upload completed.
 */
public data class GetReceiversPlainArgs(
    public val ids: List<String>? = null,
    public val keyWord: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.directmail.inputs.GetReceiversPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.directmail.inputs.GetReceiversPlainArgs =
        com.pulumi.alicloud.directmail.inputs.GetReceiversPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyWord(keyWord?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReceiversPlainArgs].
 */
@PulumiTagMarker
public class GetReceiversPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var keyWord: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: Int? = null

    /**
     * @param value A list of Receivers IDs.
     */
    @JvmName("uyqvpgfbxtardhcu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Receivers IDs.
     */
    @JvmName("sbxrjflrjeueeygg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The key word.
     */
    @JvmName("gmfcftkviwgslarq")
    public suspend fun keyWord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyWord = mapped
    }

    /**
     * @param value A regex string to filter results by Receivers name.
     */
    @JvmName("vmrargssporvonvq")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dnoyjosjcytrgyiq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid Values: `0` means uploading, `1` means upload completed.
     */
    @JvmName("ncduoiqahultbpqs")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetReceiversPlainArgs = GetReceiversPlainArgs(
        ids = ids,
        keyWord = keyWord,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
