@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.directmail.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cnameAuthStatus Indicates whether your ownership of the domain is verified.
 * @property cnameConfirmStatus Indicates whether the CNAME record is successfully verified. **Note:** `cname_confirm_status` takes effect only if `enable_details` is set to `true`.
 * @property cnameRecord The value of the CNAME record. **Note:** `cname_record` takes effect only if `enable_details` is set to `true`.
 * @property createTime The time when the DNS record was created.
 * @property defaultDomain The default domain name. **Note:** `default_domain` takes effect only if `enable_details` is set to `true`.
 * @property dkimAuthStatus (Available since v1.227.1) The DKIM validation flag. **Note:** `dkim_auth_status` takes effect only if `enable_details` is set to `true`.
 * @property dkimPublicKey (Available since v1.227.1) The DKIM public key. **Note:** `dkim_public_key` takes effect only if `enable_details` is set to `true`.
 * @property dkimRr (Available since v1.227.1) The DKIM Host Record. **Note:** `dkim_rr` takes effect only if `enable_details` is set to `true`.
 * @property dmarcAuthStatus (Available since v1.227.1) The DMARC validation flag. **Note:** `dmarc_auth_status` takes effect only if `enable_details` is set to `true`.
 * @property dmarcHostRecord (Available since v1.227.1) The DMARC Host Record. **Note:** `dmarc_host_record` takes effect only if `enable_details` is set to `true`.
 * @property dmarcRecord (Available since v1.227.1) The DMARC record. **Note:** `dmarc_record` takes effect only if `enable_details` is set to `true`.
 * @property dnsDmarc (Available since v1.227.1) The DMARC record value resolved through public DNS. **Note:** `dns_dmarc` takes effect only if `enable_details` is set to `true`.
 * @property dnsMx The MX record value resolved through public DNS. **Note:** `dns_mx` takes effect only if `enable_details` is set to `true`.
 * @property dnsSpf The SPF record value resolved through public DNS. **Note:** `dns_spf` takes effect only if `enable_details` is set to `true`.
 * @property dnsTxt The TXT record value resolved through public DNS. **Note:** `dns_txt` takes effect only if `enable_details` is set to `true`.
 * @property domainId The ID of the domain name.
 * @property domainName The domain name.
 * @property domainRecord (Available since v1.227.1) The value of the Domain record.
 * @property domainType The type of the domain. **Note:** `domain_type` takes effect only if `enable_details` is set to `true`.
 * @property hostRecord (Available since v1.227.1) The value of the host record. **Note:** `host_record` takes effect only if `enable_details` is set to `true`.
 * @property icpStatus The status of ICP filing.
 * @property id The ID of the Domain.
 * @property mxAuthStatus Indicates whether the MX record is successfully verified.
 * @property mxRecord The MX verification record provided by the Direct Mail console. **Note:** `mx_record` takes effect only if `enable_details` is set to `true`.
 * @property spfAuthStatus Indicates whether the SPF record is successfully verified.
 * @property spfRecord The SPF verification record provided by the Direct Mail console. **Note:** `spf_record` takes effect only if `enable_details` is set to `true`.
 * @property status The status of the domain name. Valid values:
 * @property tlDomainName The primary domain name. **Note:** `tl_domain_name` takes effect only if `enable_details` is set to `true`.
 * @property tracefRecord The CNAME verification record provided by the Direct Mail console. **Note:** `tracef_record` takes effect only if `enable_details` is set to `true`.
 */
public data class GetDomainsDomain(
    public val cnameAuthStatus: String,
    public val cnameConfirmStatus: String,
    public val cnameRecord: String,
    public val createTime: String,
    public val defaultDomain: String,
    public val dkimAuthStatus: String,
    public val dkimPublicKey: String,
    public val dkimRr: String,
    public val dmarcAuthStatus: String,
    public val dmarcHostRecord: String,
    public val dmarcRecord: String,
    public val dnsDmarc: String,
    public val dnsMx: String,
    public val dnsSpf: String,
    public val dnsTxt: String,
    public val domainId: String,
    public val domainName: String,
    public val domainRecord: String,
    public val domainType: String,
    public val hostRecord: String,
    public val icpStatus: String,
    public val id: String,
    public val mxAuthStatus: String,
    public val mxRecord: String,
    public val spfAuthStatus: String,
    public val spfRecord: String,
    public val status: String,
    public val tlDomainName: String,
    public val tracefRecord: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.directmail.outputs.GetDomainsDomain): GetDomainsDomain = GetDomainsDomain(
            cnameAuthStatus = javaType.cnameAuthStatus(),
            cnameConfirmStatus = javaType.cnameConfirmStatus(),
            cnameRecord = javaType.cnameRecord(),
            createTime = javaType.createTime(),
            defaultDomain = javaType.defaultDomain(),
            dkimAuthStatus = javaType.dkimAuthStatus(),
            dkimPublicKey = javaType.dkimPublicKey(),
            dkimRr = javaType.dkimRr(),
            dmarcAuthStatus = javaType.dmarcAuthStatus(),
            dmarcHostRecord = javaType.dmarcHostRecord(),
            dmarcRecord = javaType.dmarcRecord(),
            dnsDmarc = javaType.dnsDmarc(),
            dnsMx = javaType.dnsMx(),
            dnsSpf = javaType.dnsSpf(),
            dnsTxt = javaType.dnsTxt(),
            domainId = javaType.domainId(),
            domainName = javaType.domainName(),
            domainRecord = javaType.domainRecord(),
            domainType = javaType.domainType(),
            hostRecord = javaType.hostRecord(),
            icpStatus = javaType.icpStatus(),
            id = javaType.id(),
            mxAuthStatus = javaType.mxAuthStatus(),
            mxRecord = javaType.mxRecord(),
            spfAuthStatus = javaType.spfAuthStatus(),
            spfRecord = javaType.spfRecord(),
            status = javaType.status(),
            tlDomainName = javaType.tlDomainName(),
            tracefRecord = javaType.tracefRecord(),
        )
    }
}
