@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.directmail.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountName The sender address.
 * @property createTime The creation of the record time.
 * @property dailyCount On the quota limit.
 * @property dailyReqCount On the quota.
 * @property domainStatus Domain name status. Valid values: `0`, `1`.
 * @property id The ID of the Mail Address.
 * @property mailAddressId The sender address ID.
 * @property monthCount Monthly quota limit.
 * @property monthReqCount Months amount.
 * @property replyAddress Return address.
 * @property replyStatus If using STMP address status.
 * @property sendtype Account type.
 * @property status Account Status. Valid values: `0`, `1`. Freeze: 1, normal: 0.
 */
public data class GetMailAddressesAddress(
    public val accountName: String,
    public val createTime: String,
    public val dailyCount: String,
    public val dailyReqCount: String,
    public val domainStatus: String,
    public val id: String,
    public val mailAddressId: String,
    public val monthCount: String,
    public val monthReqCount: String,
    public val replyAddress: String,
    public val replyStatus: String,
    public val sendtype: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.directmail.outputs.GetMailAddressesAddress): GetMailAddressesAddress = GetMailAddressesAddress(
            accountName = javaType.accountName(),
            createTime = javaType.createTime(),
            dailyCount = javaType.dailyCount(),
            dailyReqCount = javaType.dailyReqCount(),
            domainStatus = javaType.domainStatus(),
            id = javaType.id(),
            mailAddressId = javaType.mailAddressId(),
            monthCount = javaType.monthCount(),
            monthReqCount = javaType.monthReqCount(),
            replyAddress = javaType.replyAddress(),
            replyStatus = javaType.replyStatus(),
            sendtype = javaType.sendtype(),
            status = javaType.status(),
        )
    }
}
