@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.directmail.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getMailAddresses.
 * @property addresses
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property keyWord
 * @property outputFile
 * @property sendtype
 * @property status
 */
public data class GetMailAddressesResult(
    public val addresses: List<GetMailAddressesAddress>,
    public val id: String,
    public val ids: List<String>,
    public val keyWord: String? = null,
    public val outputFile: String? = null,
    public val sendtype: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.directmail.outputs.GetMailAddressesResult): GetMailAddressesResult = GetMailAddressesResult(
            addresses = javaType.addresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.directmail.kotlin.outputs.GetMailAddressesAddress.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            keyWord = javaType.keyWord().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            sendtype = javaType.sendtype().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
