@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.directmail.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The creation time of the resource.
 * @property description The description.
 * @property id The ID of the Receivers.
 * @property receiversAlias The Receivers Alias.
 * @property receiversId The first ID of the resource.
 * @property receiversName The name of the resource.
 * @property status The status of the resource.
 */
public data class GetReceiversReceiverse(
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val receiversAlias: String,
    public val receiversId: String,
    public val receiversName: String,
    public val status: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.directmail.outputs.GetReceiversReceiverse): GetReceiversReceiverse = GetReceiversReceiverse(
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            receiversAlias = javaType.receiversAlias(),
            receiversId = javaType.receiversId(),
            receiversName = javaType.receiversName(),
            status = javaType.status(),
        )
    }
}
