@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.directmail.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getReceivers.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property keyWord
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property receiverses
 * @property status
 */
public data class GetReceiversResult(
    public val id: String,
    public val ids: List<String>,
    public val keyWord: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val receiverses: List<GetReceiversReceiverse>,
    public val status: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.directmail.outputs.GetReceiversResult): GetReceiversResult = GetReceiversResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            keyWord = javaType.keyWord().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            receiverses = javaType.receiverses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.directmail.kotlin.outputs.GetReceiversReceiverse.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
